"Macro Data Sheet file v. 1" 
gamesystem GURPS 

title "GURPS Character Templates (v. 3.0.0)"

version 253
level 3

copyright "Copyright  1998, 1999, 2001-2003 Steve Jackson Games Incorporated. All rights reserved. \
GURPS is a registered trademark of Steve Jackson Games Incorporated."

$$define PLUGIN W

datafile 
	GURPSCompendium.cds 
	end

$$include gurps.inc
$$include GURPSTemplates.inc

logo GURPS/Wizards.lgo

# The categories of items follow.

cat "Advantages"
	sublist "Templates" memlist
		sublist Warrior memlist
			$$template	Warrior	Archer	75	11	13	10	11
				$$choose	Advantages	20	Acute Vision,Alertness,Combat Reflexes,Fit,High Pain Threshold,Toughness,ST+1
				$$choose	Disadvantages	-20	Bloodlust,Callous,Chummy,Gregarious,Code of Honor,Overconfidence,Sense of Duty[Sense of Duty (Comrades in Arms)],Poverty
				$$req	Skills	Axe/Mace=12 OR Broadsword=12 OR Shortsword=12,Bow=14 OR Crossbow=16,Fast-Draw[Fast-Draw (Arrow)]=14 OR Sling=14,2:*Combat/Weapon
				$$req	Skills	Armoury=11,Hiking=11,*Survival=11
				$$choose	Skills	4	?title{Choose Background Skills}First Aid,Camouflage,Cooking,Savoir-Faire (Military),Scrounging,Leadership,Tracking,Tactics,Brawling,Knife,Stealth,Running,Agronomy,*Craft
			$$template	Warrior	Artilleryman/Gunner	55	11	11	11	10
				$$choose	Advantages	20	Acute Vision,Combat Reflexes,Cool,Fit,High Pain Threshold,Mathematical Ability,Toughness,ST+1
				$$choose	Disadvantages	-20	Bloodlust,Callous,Chummy OR Gregarious,Code of Honor,Hard of Hearing,Overconfidence,Sense of Duty[Sense of Duty (Comrades in Arms)]
				$$req	Skills	*Gunner=14,Forward Observer=12
				$$req	Skills	*Mechanic=11,First Aid=11,Savoir-Faire (Military)=11
				$$req	Skills	Engineer (Combat)=10
				$$append	TL>=1 and TL<=3	Armoury=11,Carpentry=11,Hiking=10 OR Riding=11,Axe/Mace=12 OR Broadsword=12 OR Shortsword=12
				$$append	TL>=4 and TL<=5	Armoury[Armoury (Artillery)]=11,Mathematics=10,Black Powder Weapons=13 OR Guns=13,Broadsword=12 OR Spear=12
				$$append	TL>=6 and TL<=7	Armoury[Armoury (Artillery)]=11,Driving=11,Electronics Operation (Communications)=11,Guns (Rifle)=13,Orienteering=11
				$$append	TL>=8	Armoury[Armoury (Artillery)]=11,Driving=11,Electronics Operation (Communications)=11,*Guns=12 OR *Beam Weapons=12,Orienteering=11

				$$choose	Skills	6	Camouflage,Cooking,Scrounging,Administration,Armoury,Leadership,Orienteering,*Survival,Tactics,Brawling,Knife,Gunner,Hiking
				$$append	TL>=1 and TL<=3	Animal Handling,Teamster
				$$append	TL>=4 and TL<=5	Animal Handling,Black Powder Weapons,Hiking,Riding,Teamster
				$$append	TL>=6 and TL<=7	Computer Operation,Driving,Electronics Operation (Sensors),*Guns,Spear
				$$append	TL>=8	*Beam Weapons,*Driving,*Guns,Piloting (Contragravity)

			$$template	Warrior	Aviator	75	10	12	12	11			6
				$$choose	Advantages	20	Absolute Direction,3D Spatial Sense,Acceleration Tolerance,Acute Vision,Combat Reflexes,Charisma,Danger Sense,Reputation
				$$choose	Disadvantages	-20	Bloodlust,Callous,Code of Honor,Impulsiveness,Jealousy,Loner,Overconfidence OR Glory Hound,Sense of Duty,Workaholic
				$$req	Skills	*Piloting=14,*Gunner=14,Aviation=12
				$$req	Skills	Electronics Operation (Communications)=11,Navigation=12,Savoir-Faire (Military)=11
				$$append	TL=6	Armoury[Armoury (Vehicle Weaponry)]=10,Guns=13,Mechanic=10,Parachuting=12
				$$append	TL=7	Electronics Operation (Sensors)=11,Guns (Pistol)=13,Parachuting=12
				$$append	TL>=8	Computer Operation=12,Electronics Operation (Sensors)=11,Guns=13 OR Beam Weapons=13
				$$choose	Skills	5	Armoury[Armoury (Vehicle Weaponry)],Forward Observer,Mechanic,Photography,*Survival,Tactics,*Guns,*Gunner,*Piloting,Carousing
				$$append	TL=6	Throwing
				$$append	TL=7	Computer Operation,No-Landing Extraction
				$$append	TL>=8	Astrogation,*Beam Weapons,No-Landing Extraction,Vacc Suit,Free Fall

			$$template	Warrior	Barbarian	80	12	12	10	11
				$$select	Region	Arctic,Jungle,Northern,Plains
				$$choose	Advantages	15	Alertness,Ally Group,Animal Empathy,Combat Reflexes,Danger Sense,Disease-Resistant,Fit,High Pain Threshold,Rapid Healing,Resistant to Poison,Toughness,ST+1,DX+1,HT+1
				$$choose	Disadvantages	-25	!Primitive,Bloodlust,Bully,Callous,Odious Personal Habit,Overconfidence,*Phobia,Barbarian,Uneducated
				$$req	Skills	Stealth=12,*Survival=12
				$$req	Skills	Cooking=11,Tracking=11
				$$req	?{Region='Plains'}Skills	Camouflage,Riding=13 OR Running=11
				$$choose	?{Region='Plains'}Skills	8	First Aid,Fishing,Animal Guise,Armoury,Meteorology,Animal Handling,Brawling,Knife,Swimming,*Mimicry,Throwing,Bard,Equestrian Acrobatics,Navigation,Horse Archery
				$$choose	?{Region!='Plains'}Skills	5	First Aid,Fishing,Animal Guise,Armoury,Meteorology,Animal Handling,Brawling,Knife,Swimming,*Mimicry,Throwing
				$$append	Region='Arctic'	Bard
				$$req	?{Region='Arctic'}Skills	Boating=12,Harpoon=12,Hiking=11,Navigation=10,Bow and Palette=12 OR Flint Sparking=12,Spear=14 OR Axe/Mace=14
				$$req	?{Region='Jungle'}Skills	Camouflage=11,Climbing=12,Running=10
				$$choose	?{Region='Jungle'}Skills	12	Brawling,Knife,Spear Throwing,Axe/Mace OR Spear,Bow OR Blowpipe
				$$choose	?{Region='Jungle'}Skills	3	Bard,Boating,Poisons,Traps
				$$req	?{Region='Northern'}Skills	Hiking=11,Brawling=14 OR Knife=14
				$$spec	?{Region='Northern'}Weapons	Weapon and Shield	Skills	Broadsword=14 OR Spear=14 OR Axe/Mace=14,Shield=14
				$$spec	?{Region='Northern'}Weapons	Spear	Skills	Spear=14,Spear Throwing=14
				$$spec	?{Region='Northern'}Weapons	Two-Handed Axe	Skills	Two-Handed Axe/Mace=14,Brawling=14 OR Knife=14
				$$choose	?{Region='Northern'}Skills	7	Carousing,Intimidation,Navigation,Seamanship,Shipbuilding,Skaldic Lore,*Craft
				$$choose	?{Region='Plains'}Skills	12	Brawling,Knife,Spear Throwing,Axe/Mace,Spear,Bow

			$$template	Warrior	Battlesuit Trooper	75	10	12	12	11			8
				$$choose	Advantages	15	Acceleration Tolerance,Alertness,Ally OR Ally Group,Combat Reflexes,Fit,High Pain Threshold,Luck,Patron,3D Spatial Sense,Toughness,Interface Talent
				$$choose	Disadvantages	-20	Bloodlust,Callous,Code of Honor,Intolerance[Intolerance (Non-Mechanized Soldiers)],Impulsiveness,Overconfidence,Post-Combat Shakes,Selfish,Sense of Duty[Sense of Duty (Comrades in Arms)]
				$$req	Skills	Battlesuit=14 OR Driving (Mecha)=14,*Gunner=14
				$$choose	Skills	#1	Brawling=14,*Gunner=15,Piloting (Mecha)=13,Judo=12 OR Karate=12
				$$req	Skills	Armoury[Armoury (Vehicle Weaponry)]=11,Electronics Operation (Communications)=12,Electronics Operation (Sensors)=12, First Aid=12,Forward Observer=11,Mechanic[Mechanic (Robotics)]=11,Tactics=11
				$$req	Skills	*Driving=11,Savoir-Faire (Military)=12
				$$choose	Skills	4	Camouflage,Leadership,Orienteering,*Survival,Vacc Suit,Astrogation,Navigation,Strategy,*Beam Weapons,Brawling,*Guns,Parachuting,Carousing

			$$template	Warrior	Berserker	90	13	11	10	12
				$$choose	Advantages	30	!Hard to Kill,Ambidexterity,Combat Reflexes,Daredevil,Extra Fatigue,Extra Hit Points,Fit,High Pain Threshold,Rapid Healing,Toughness,HT+1,ST+1
				$$choose	Disadvantages	-35	!Berserk OR Compulsive Behavior[Compulsive Behavior (Fighting)]=Severe OR Fanaticism OR On The Edge
				$$append	Addiction,Bad temper,Bloodlust,Bully,Callous,Disciplines of Faith,Impulsiveness,Odious Personal Habit,Overconfidence,Stubbornness
				$$choose	?{TL<6}Skills	#1	Axe/Mace=14,Broadsword=14,Two-Handed Axe/Mace=14,Two-Handed Sword=14,Flail=13
				$$req	?{TL>=6}Skills	*Combat/Weapon=13,*Guns=15 OR *Gunner=14
				$$req	Skills	Intimidation=11,Brawling=12 OR Knife=12
				$$req	Skills	*Armoury=10,First Aid=10,Running=11
				$$choose	Skills	8	Brawling,Carousing,Knife,Stealth,Survival,Philosophy,Theology

			$$template	Warrior	Cavalryman	75	11	13	11	10
				$$choose	Advantages	20	Alertness,Combat Reflexes,Fearlessness,Fit,High Pain Threshold,Reputation,Toughness
				$$choose	Disadvantages	-20	Bloodlust,Callous,Chummy OR Gregarious,Code of Honor,Intolerance[Intolerance (Regular Infantry)],Jealousy,Overconfidence OR Glory Hound,Sense of Duty
				$$req	Skills	Riding=14,Broadsword=14 OR Axe/Mace=14
				$$req	Skills	Armoury[Armoury (Small Arms)],First Aid=11,Tactics=10,Savoir-Faire (Military)=11,Veterinary=10
				$$choose	Skills	5	Cooking,Scrounging,Administration,Animal Handling,Leadership,Orienteering,*Survival,Brawling,Knife
				$$req	?{TL<4}Skills	Lance=13,Shield=14
				$$req	?{TL=4}Skills	*Black Powder Weapons=16
				$$choose	?{TL>4}Skills	4	Guns (Pistol),Guns (Rifle),Speed-Load

			$$template	Warrior	Commando	130	11	13	13	11			6
				$$choose	Advantages	25	Fit,Breath-Holding,Combat Reflexes,Daredevil,Fearlessness,High Pain Threshold,Reputation,Toughness,ST+1,HT+1
				$$req	Disadvantages	Fanaticism
				$$choose	Disadvantages	-15	Bloodlust,Callous,Chummy OR Gregarious,Code of Honor,Intolerance,Overconfidence,Sense of Duty
				$$req	?{TL<8}Skills	*Guns=16,*Guns=16,*Gunner=15,Orienteering=13,Stealth=14,Tactics=14
				$$req	?{TL>=8}Skills	*Beam Weapons=16,*Beam Weapons=16,*Gunner=15,Orienteering=13,Stealth=14,Tactics=14
				$$req	Skills	*Survival=12,*Survival=12,Brawling=14,Camouflage=13,Climbing=13
				$$req	?{TL<8}Skills	*Guns=15,Armoury[Armoury (Rifles and Handguns)]=12
				$$req	?{TL>=8}Skills	*Beam Weapons=15,Armoury[Armoury (Beam Weapons)]=12
				$$req	Skills	Demolition=12,Electronics Operation (Communications)=12,Engineer (Combat)=11,First Aid=12,Jumping=13,Knife=12,Parachuting=13
				$$req	Skills	Savoir-Faire (Military)=12,Scrounging,Traps=12
				$$req	Skills	Administration=11,Driving (Automobile)=12,Forward Observer=11,Interrogation=11,Leadership=11,Nuclear-Biological-Chemical Warfare=11,No-Landing Extraction=12,Swimming=12,Throwing=11
				$$select	Specialty	Communications,Demolition,Medical,Weapons

				$$choose	?{Specialty='Communications'}Skills	14	Electronics Operation,*Electronics Operation
				$$choose	?{Specialty='Demolition'}Skills	14	Demolition,Engineer (Combat),Traps,Explosive Ordnance Disposal
				$$choose	?{Specialty='Medical'}Skills	14	First Aid,Diagnosis,Surgery
				$$choose	?{Specialty='Weapons' and TL<8}Skills	14	Armoury[Armoury (Rifles and Handguns)],Gunner (Machine Gun),Guns (Grenade Launcher),Guns (Light Antitank Weapon),Guns (Light Automatic),Guns (Pistol),Knife
				$$choose	?{Specialty='Weapons' and TL>=8}Skills	14	Armoury[Armoury (Beam Weapons)],Gunner (Machine Gun),Guns (Grenade Launcher),Guns (Light Antitank Weapon),Guns (Light Automatic),Guns (Pistol),Knife

			$$template	Warrior	Combat Engineer	75	11	11	12	10
				$$choose	Advantages	15	!Literacy,Alertness,Combat Reflexes,Fit,High Pain Threshold,Manual Dexterity,Mathematical Ability,Toughness,Versatile
				$$choose	Disadvantages	-15	Callous,Chummy OR Gregarious,Code of Honor,Edgy,Hard of Hearing,Overconfidence,Post-Combat Shakes,Sense of Duty
				$$req	Skills	Engineer (Combat)=14
				$$req	Skills	Armoury[Armoury (Small Arms)]=11 OR Armoury[Armoury (Siege Engines)]=11,Camouflage=12,First Aid=12,Surveying=11,Savoir-Faire (Military)=12
				$$choose	Skills	5	Carpentry,Scrounging,Administration,Leadership,*Survival,Strategy,Tactics,Brawling,Knife,*Gunner,Stealth
				$$append	TL<4	Blacksmith,Cooking,Woodworking,Riding
				$$append	TL>3 and TL<7	Blacksmith,Cooking,Woodworking,Riding
				$$append	TL>6	Computer Operation,*Driving

				$$req	?{TL<4}Skills	Mechanic[Mechanic (Primitive Machines)]=12,Engineer (Simple Machines)=12,Mathematics=12
				$$choose	?{TL<4}Skills	7	Brawling,Knife,Shield,Axe/Mace,Shortsword,Spear

				$$req	?{TL>3 and TL<7}Skills	Demolition=13
				$$choose	?{TL>3 and TL<7}Skills	4	*Guns,*Black Powder Weapons
				$$choose	?{TL>3 and TL<7}Skills	9	Mechanic,Explosive Ordnance Disposal,Throwing,Hiking,Riding,Shortsword,Spear

				$$req	?{TL>6}Skills	Demolition=13,Traps=12
				$$choose	?{TL>3 and TL<7}Skills	4	*Guns,*Beam Weapons
				$$choose	?{TL>3 and TL<7}Skills	7	Electronics Operation (Communications),Electronics Operation (Sensors),Mechanic,*Professional

			$$template	Warrior	Gladiator	90	12	12	10	11
				$$choose	Advantages	20	!Fit,Combat Reflexes,Extra Hit Points,Extra Fatigue,Hard to Kill,High Pain Threshold,Peripheral Vision,Rapid Healing,Reputation,Toughness,ST+1,DX+1,HT+1
				$$choose	Disadvantages	-20	Bad Temper,Bloodlust,Bully,Callous,Code of Honor,Enemy,Extremely Hazardous Duty,Greed,Loner,Overconfidence OR Glory Hound,Reputation,Social Stigma,Appearance
				$$choose	Skills	16	*Melee
				$$req	Skills	Acrobatics=11,Armoury[Armoury (Hand Weapons)]=11,Body Language=11,Savoir-Faire (Dojo)=11,Tournament Law=11
				$$choose	Skills	#1	Intimidation=11,Performance=11,Sports=13

			$$template	Warrior	Guard	75	11	12	12	10
				$$choose	Advantages	#1	Alertness=3,Combat Reflexes,Danger Sense
				$$choose	Disadvantages	-20	!Duty=9 or less,Callous,Code of Honor,Edgy,Gigantism,Light Sleeper,On the Edge,No Sense of Humor,Overconfidence,Selfless,Sense of Duty[Sense of Duty (Client)]
				$$req	Skills	Body Language=12,Intimidation=12,Shadowing=12,Brawling=14 OR Boxing=13 OR Judo=12 OR Karate=12
				$$choose	Skills	8	*Combat/Weapon
				$$req	Skills	Diplomacy=11,Tactics=11,Criminology=11 OR Streetwise=11,Detect Lies=10 OR Interrogation=11
				$$req	Skills	Poisons=11 OR Holdout=12 OR Traps=12
				$$req	Skills	Armoury[Armoury (Small Arms)]=11 OR Armoury[Armoury (Handweapons)]=11,First Aid=11,Savoir-Faire=11

			$$template	Warrior	Guerilla/Partisan	75	10	11	12	10
				$$choose	Advantages	20	Alertness,Ally Group,Combat Reflexes,Composed,Contacts,Danger Sense,Higher Purpose,Sanctity,Versatile,Zeroed
				$$req	Disadvantages	Enemy[Enemy (Government)]=Formidable Group{Roll=6 or less} OR Secret=Imprisonment or Exile
				$$req	Skills	Area Knowledge=14,Camouflage=12,Stealth=13,Streetwise=12 OR Orienteering=12
				$$choose	Skills	12	*Combat/Weapon
				$$req	Skills	First Aid=12,Scrounging=12,Tactics=11,Acting=12 OR Survival=12,Demolition=12 OR Traps=12
				$$req	Skills	Hiking=10 OR Riding=12 OR Driving=11
				$$choose	Skills	6	*Armoury,Holdout,Leadership,Shadowing,Intelligence Analysis,Strategy

			$$template	Warrior	Gunslinger	80	10	13	11	10			5
				$$req	Advantages	Combat Reflexes
				$$choose	Advantages	25	Alertness,Ambidexterity,Composed OR Imperturbable,Daredevil,Increased Speed,High Pain Threshold,Manual Dexterity,Reputation,Toughness,DX+1
				$$choose	Disadvantages	-25	Bad Temper,Bloodlust,Callous,Code of Honor,Enemy,Jealousy,Loner,Obsession[Obsession (Prove You're the Fastest)],On the Edge,Overconfidence OR Glory Hound,Reputation,Sense of Duty
				$$req	Skills	Fast-Draw[Fast-Draw (Pistol)]=15,Guns (Pistol)=16,Intimidation=12
				$$req	Skills	Riding=12 OR Driving=12,Armoury[Armoury (Rifles and Handguns)]=11,Body Language=10,Carousing=10,Speed-Load=13,Streetwise=11
				$$choose	Skills	5	First Aid,Savoir-Faire,Holdout,Gambling,*Survival,Tactics,Brawling,*Guns,Knife,Sleight of Hand

			$$template	Warrior	Holy Warrior	90	11	12	12	11
				$$choose	Advantages	25	!Blessed OR Clerical Investment OR Divine Favor OR True Faith,Combat Reflexes,High Pain Threshold,Higher Purpose,Literacy,Luck,Military Rank,Oracle,Patron (Church),Status,Toughness
				$$choose	Disadvantages	-30	Disciplines of Faith,Code of Honor,Duty[Duty (Church)],Fanaticism,Intolerance[Intolerance (Religion)],Overconfidence,Sense of Duty,Vow=Minor
				$$req	Skills	Theology=12 OR Philosophy=12
				$$choose	Skills	16	*Combat/Weapon
				$$req	Skills	Tactics=11,Performance/Ritual=12 OR Bard=12
				$$choose	Skills	4	Astrology,Diplomacy,Law[Law (Religious)],Occultism,Teaching
				$$req	Skills	Armoury=11
				$$choose	Skills	5	First Aid,Administration,Leadership,Politics,Detect Lies,Exorcism,Sacrifice,Psychology,Meditation,Musical Instrument,Singing,Dancing,Riding

			$$template	Warrior	Horseman	75	11	13	10	11
				$$advs	15	Alertness,Ally Group,Animal Empathy OR Beast-Kin,Combat Reflexes,Danger Sense,Fit,High Pain Threshold,Toughness,ST+1,HT+1
				$$disadvs	-20	Bad Temper,Bloodlust,Bowlegged,Callous,Chummy OR Gregarious,Code of Honor,Impulsiveness,Overconfidence,Semi-Literate OR Illiteracy,Sense of Duty,Barbarian,Uneducated
				$$skills	Riding=14,Axe/Mace=13 OR Broadsword=13 OR Shortsword=13 OR Spear=13
				$$select	Weapon	Lance,Ranged
				$$req	?{Weapon='Lance'}Skills	Lance=15
				$$choose	?{Weapon='Ranged'}Skills	8	*Ranged
				$$skills	Armoury=11,First Aid=11,*Survival=11
				$$skills	6	Animal Handling,Area Knowledge,Brawling,Equestrian Acrobatics,Knife,Leadership,Orienteering,Tactics,Veterinary

			$$template	Warrior	Heavy Foot Soldier	65	12	12	10	11
				$$advs	15	Combat Reflexes,Composed,Extra Fatigue,Extra Hit Points,Fearlessness,Fit,High Pain Threshold,Strong Will,Toughness,ST+1,DX+1,HT+1
				$$disadvs	-25	Bloodlust,Callous,Chummy OR Gregarious,Code of Honor,Obdurate,Overconfidence,Post-Combat Shakes,Sense of Duty
				$$skills	Axe/Mace=14 OR Broadsword=14 OR Shortsword=14 OR Spear=14,Shield=14 OR Polearm=14,4:*Combat/Weapon
				$$skills	Armoury=11,Tactics=9{Specialty=Drill},Hiking=11
				$$skills	First Aid=10,Savoir-Faire (Military)=10
				$$skills	3	*Craft,Cooking,Scrounging,Agronomy,Gambling,Leadership,Orienteering,*Survival,Brawling,Knife,Carousing

			$$template	Warrior	Knight	90	12	13	10	11
				$$advs	25	!Status=2,Combat Reflexes,Fit,Heir,High Pain Threshold,Patron,Reputation,Semi-Literacy OR Literacy,Toughness,Wealth
				$$disadvs	-20	Bloodlust,Callous,Code of Honor,Disowned,Duty,Intolerance,Jealousy,Overconfidence OR Glory Hound,Selfish OR Self-Centered,Sense of Duty,Vow
				$$skills	Riding=13,12:*Combat/Weapon
				$$skills	Leadership=11,Savoir-Faire=12
				$$skills	Heraldry=10
				$$skills	5	*Armoury,Poetry,Politics,Diplomacy,Strategy,Tactics,Tea Ceremony,Appreciate Beauty,Dancing,Carousing

			$$template	Warrior	Light Foot Soldier	60	11	12	10	11
				$$advs	15	Alertness,Combat Reflexes,Extra Fatigue,Fit,High Pain Threshold,Toughness,ST+1,DX+1,HT+1
				$$disadvs	-20	Bloodlust,Callous,Chummy OR Gregarious,Code of Honor,Cowardice,Impulsiveness,Overconfidence,Post-Combat Shakes,Poverty,Sense of Duty,Short Attention Span,Status,Weak Will
				$$skills	Hiking=12,4:*Melee,4:*Ranged
				$$skills	Running=11,Stealth=11
				$$skills	Armoury=10
				$$skills	6	Cooking,First Aid,Savoir-Faire (Military),Scrounging,Agronomy,Leadership,Orienteering,*Survival,Tracking,Tactics,Brawling,Knife,Carousing,*Craft
			##template(Warrior, Heroic Knight, 90, 12, 13, 11, 12)
				##advs	Wealth=1,Status=2
				##disadvs	Duty[Duty (Liege Lord)]=9 or less
				##disadvs	-25	Charitable,Code of Honor[Code of Honor (Chivalry)]=Restrictive,Compulsive Vowing,Honesty,Pacifism (Cannot Harm Innocents),Selfless,Sense of Duty[Sense of Duty (Nation)]=2,Truthfulness,Vow[Vow (Never Refuse a Request for Aid)]=Great
				##skills	Broadsword=14 OR Axe/Mace=14,Lance=14,Riding=13,Shield=14
				##skills	Leadership=11,Tactics=11
				##skills	Armoury=10,Heraldry=10

			$$template	Warrior	Marine	75	11	12	11	11
				$$select	?{TL>7}Location	Planetbound,Space-Going
				$$select	?{TL>=6}Specialization	Admin/Supply,Medical,Infantry

				$$choose	?{Location<>'Space-Going'}Advantages	15	Breath-Holding,Combat Reflexes,Extra Fatigue,Fit,Hard to Kill,High Pain Threshold,Reputation,Toughness,ST+1,DX+1,HT+1
				$$choose	?{Location='Space-Going'}Advantages	15	Breath-Holding,Combat Reflexes,Extra Fatigue,Fit,Hard to Kill,High Pain Threshold,Reputation,Toughness,ST+1,DX+1,HT+1,3D Spatial Sense,Improved G-Tolerance,G-Experience
				$$disadvs	-25	Bloodlust,Callous,Chummy OR Gregarious,Code of Honor,Fanaticism,Intolerance,Overconfidence OR Glory Hound,Post-Combat Shakes,Sense of Duty,Workaholic
				$$req	?{TL<6}Skills	ST+1 OR HT+1,Boating=12,Climbing=12,Jumping=12,Seamanship=11,Broadsword=14 OR Shortsword=14 OR Spear=14,4:*Ranged
				$$req	?{TL>=6 and Specialization<>'Infantry'}Skills	Guns (Rifle)=14 OR Guns (Light Automatic)=14 OR *Beam Weapons=14
				$$req	?{TL>=6 and Specialization='Infantry'}Skills	Guns (Rifle)=15 OR Guns (Light Automatic)=15 OR *Beam Weapons=15
				$$req	?{TL>=6 and Location<>'Space-Going'}Skills	Camouflage=11,Swimming=11,Electronics Operation (Communications)=11,First Aid=11,Hiking=11,Climbing=10,Jumping=11,Spear=10,*Survival=10,Orienteering=11,Nuclear-Biological-Chemical Warfare=11
				$$req	?{Location='Space-Going'}Skills	Free Fall=12,Vacc Suit=11,Computer Operation=11,First Aid=11,Electronics Operation (Communications)=11,Gesture=11,Battlesuit=12 OR Exoskeleton=12,Beam Weapons=14 OR Guns=14

				$$skills	Armoury=11,Savoir-Faire (Military)=12

				$$skills	3	Brawling,Carousing,First Aid,Knife,Leadership,Survival (Island/Beach),Swimming,Tactics
				$$append	TL<6	Cooking,Fishing,Riding
				$$append	TL>=6 and Location<>'Space-Going'	Engineer (Combat),Driving,Forward Observer,Parachuting,Powerboat

				$$req	?{Specialization='Admin/Supply'}Skills	Administration=13 OR Mechanic=13,Computer Operation=13 OR Cooking=13 OR Scrounging=13 OR Driving (Heavy Wheeled) OR Piloting (Contragravity),1:*Driving
				$$choose	?{Specialization='Medical'}Skills	13	!First Aid=13,Diagnosis,Surgery
				$$req	?{Specialization='Infantry'}Skills	*Gunner=12 OR Guns (Grenade Launcher),*Guns=14 OR *Beam Weapons=14,Tactics=11

			$$template	Warrior	Martial Artist	90	11	13	10	11								GURPSMartialArts.cds
				$$advs	20	Combat Reflexes,Daredevil,Fit,High Pain Threshold,Iron Hand,Strong Will,Style Familiarity,Toughness
				$$disadvs	-20	Bad Temper,Bully,Code of Honor,Cowardice,Enemy,Obsession[Obsession (Become a Master)],*Pacifism,Vow[Vow (Use No Weapons)]

				$$select	Select combat skills from GURPS Martial Arts or Basic Set?	Skills	Martial Arts,Basic Set

				$$skills	Acrobatics=13,Jumping=13,Intimidation=12 OR Leadership=12 OR Teaching=12
				$$skills	5	First Aid,Savoir-Faire (Dojo),Body Language,Style Analysis,Tactics,Meditation,Physiology,Knife,Stealth

				$$req	?{Skills='Martial Arts'}Skills	*Martial Arts Style
				$$choose	?{Skills<>'Martial Arts'}Skills	#3	Brawling=16,Boxing=15,Jitte/Sai=15,Sumo=15,Wrestling=15,Flail=14,Judo=15,Karate=14,Short Staff=14,Staff=14,Tonfa=14

			$$template	Warrior	Naval Crew	75	10	12	12	11
				$$advs	15	Absolute Direction,Acute Vision,Ally Group,Breath-Holding,Combat Reflexes,Fit,High Pain Threshold,Mathematical Ability,Reputation,Toughness,IQ+1,ST+1
				$$disadvs	-25	Bloodlust,Callous,Chummy OR Gregarious,Code of Honor,Fanaticism,Odious Personal Habit,Overconfidence,Sense of Duty
				$$skills	Sailor=12,Seamanship=12
				$$skills	Carousing=11 OR Savoir-Faire [Savoir-Faire (Military)]=13 OR Streetwise=12
				$$req	?{TL<=5}Skills	Climbing=12,Jumping=12,8:*Combat/Weapon
				$$req	?{TL>5}Skills	Armoury=11,First Aid=12,Guns=15,Nuclear-Biological-Chemical Warfare=11,Swimming=12
				$$choose	?{TL>5}Skills	2	Computer Operation,Electronics Operation (Communications),Mechanic
				$$choose	?{TL>5}Skills	3	Administration,Driving,*Guns,Powerboat
				$$select	?{TL<5}Specialty	Carpenter/Cooper,Deck Hand,Gunner,Helmsman
				$$select	?{TL=5}Specialty	Carpenter/Cooper,Deck Hand,Gunner,Helmsman,Engineer
				$$select	?{TL>=6}Specialty	Communications,Deck Hand,Diver,Engineer,Gunner,Helmsman

				$$req	?{Specialty='Carpenter/Cooper'}Skills	Carpentry=14,Cooperage=13,Scrounging=13,Shipbuilding=13
				$$req	?{Specialty='Communications'}Skills	Electronics Operation (Communications)=14,Traffic Analysis=14
				$$req	?{Specialty='Deck Hand'}Skills	Freight Handling=12,Climbing=13,ST+1 OR DX+1 OR HT+1
				$$req	?{Specialty='Diver'}Skills	Hard-Hat Diving=14 OR Scuba=14,Swimming=15
				$$choose	?{Specialty='Diver'}Skills	5	Demolition,Mechanic[Mechanic (Ocean-Going Vessel)],Underwater Demolition,Shipbuilding
				$$req	?{Specialty='Engineer'}Skills	Engineer (Vehicle)=12,Mechanic (Marine Vessel)=14,Shipbuilding=12
				$$req	?{Specialty='Helmsman'}Skills	Area Knowledge[Area Knowledge (Ocean/Sea/Coastline)]=13,Meteorology=12,Navigation=12,Shiphandling=13

			$$template	Warrior	Rifleman	75	11	12	11	11			4
				$$select	?{TL>5}Specialty	Admin/Supply,Medical,Infantry
				$$advs	15	Combat Reflexes,Composed OR Imperturbable,Fearlessness,Fit,High Pain Threshold,Reputation,Toughness,ST+1,DX+1,HT+1
				$$req	?{TL<6}Advantages	ST+1
				$$disadvs	-25	Bloodlust,Callous,Chummy OR Gregarious,Code of Honor,Fanaticism,Intolerance,Overconfidence,Sense of Duty,Workaholic
				$$skills	Savoir-Faire (Military)
				$$skills	Armoury=11,Hiking=11
				$$choose	?{TL<6}Skills	4	Cooking,First Aid,Scrounging,Leadership,Gambling,Survival,Brawling,Knife,Carousing,Agronomy,Animal Handling,*Craft
				$$choose	?{TL>=6}Skills	4	Cooking,First Aid,Scrounging,Leadership,Gambling,Survival,Brawling,Knife,Carousing
				$$append	Computer Operation,Driving,Forward Observer,Parachuting,Spear,Tactics
				$$req	?{TL<6}Skills	*Rifle=12 OR Guns (Rifle)=14,Speed-Load=11,Tactics=8{Specialty=Drill}
				$$choose	?{TL<6}Skills	8	Axe/Mace,Broadsword,Shortsword,Spear
				$$choose	?{TL<6}Skills	4	Hiking,Riding,Running
				$$req	?{TL>=6 and TL<8 and Specialty <> 'Infantry'}Skills	Guns (Rifle)=14 OR Guns (Light Automatic)=14,Camouflage=1,Climbing=11,Electronics Operation (Communications)=11,First Aid=11,Orienteering=11,Nuclear-Biological-Chemical Warfare=11,*Survival=11,Throwing=10
				$$req	?{TL>=6 and TL<8 and Specialty = 'Infantry'}Skills	Guns (Rifle)=15 OR Guns (Light Automatic)=15,Camouflage=1,Climbing=11,Electronics Operation (Communications)=11,First Aid=11,Orienteering=11,Nuclear-Biological-Chemical Warfare=11,*Survival=11,Throwing=10
				$$req	?{TL>=8 and Specialty <> 'Infantry'}Skills	Guns (Rifle)=14 OR Guns (Light Automatic)=14 OR *Beam Weapons=14,Camouflage=1,Climbing=11,Electronics Operation (Communications)=11,First Aid=11,Orienteering=11,Nuclear-Biological-Chemical Warfare=11,*Survival=11,Throwing=10
				$$req	?{TL>=8 and Specialty = 'Infantry'}Skills	Guns (Rifle)=15 OR Guns (Light Automatic)=15 OR *Beam Weapons=15,Camouflage=1,Climbing=11,Electronics Operation (Communications)=11,First Aid=11,Orienteering=11,Nuclear-Biological-Chemical Warfare=11,*Survival=11,Throwing=10
				$$req	?{Specialty='Admin/Supply'}Skills	Administration=13 OR Mechanic=13,Computer Operation=13 OR Cooking=13 OR Scrounging=13,Driving (Heavy Wheeled)=12 OR Piloting (Contragravity)=12
				$$choose	?{Specialty='Medical'}Skills	14	!First Aid=13,Diagnosis,Surgery
				$$req	?{Specialty='Infantry'}Skills	*Gunner=14 OR Guns (Grenade Launcher)=15,*Guns=14 OR *Beam Weapons=14,Tactics=11,Stealth=12

			$$template	Warrior	Scout	90	11	13	12	11
				$$advs	20	Absolute Direction,Alertness,Animal Empathy OR Beast-Kin,Combat Reflexes,Disease-Resistant,Fit,High Pain Threshold,Plant Empathy OR Tree-Kin,Resistant to Poison,Toughness
				$$disadvs	-30	Callous,Code of Honor,Curious,Easy to Read,Impulsiveness,Loner OR Reclusive,Low Empathy,No Sense of Humor,Odious Personal Habit,Overconfidence,Semi-Literacy OR Illiteracy,Sense of Duty,Shyness,Poverty,Stubbornness,Uneducated,Vow
				$$skills	Stealth=14,*Survival=12
				$$skills	12	*Combat/Weapon
				$$skills	Camouflage=12,Hiking=11,Tracking=12,Navigation=11 OR Orienteering=12
				$$skills	Traps=11 OR Fishing=12,Cooking=12
				$$skills	3	Area Knowledge,Armoury,Meteorology,Naturalist,Climbing,Swimming,Mimicry (Bird Calls) OR Mimicry (Animal Sounds),Running

			$$template	Warrior	Sharpshooter Warrior	90	11	14	11	10			4
				$$advs	20	Acute Vision,Alertness,Combat Reflexes,Composed OR Imperturbable,Fearlessness,Fit,High Pain Threshold,Intuition,Single-Minded,Strong Will
				$$disadvs	-20	Bloodlust,Callous,Code of Honor,Enemy,Fanaticism,Flashbacks,Intolerance,Loner OR Reclusive,Nightmares,No Sense of Humor,Overconfidence,Reputation,Sense of Duty,Stubbornness,Trademark
				$$req	?{TL<6}Skills	*Rifle=18
				$$req	?{TL>=6 and TL<8}Skills	Guns (Rifle)=18
				$$req	?{TL>7}Skills	Guns (Rifle)=18 OR *Beam Weapons=18
				$$skills	Camouflage=13,Stealth=14
				$$skills	Armoury=11,Climbing=13,Orienteering=12 OR Navigation=12
				$$skills	Hiking=10
				$$skills	2	Savoir-Faire (Military),Survival,Tracking,Tactics
				$$append	TL>5	Electronics Operation (Communications) OR Electronics Operations (Sensors),Driving
				$$append	TL<6	Riding

			$$template	Warrior	Slayer	85	11	12	13	10
				$$advs	20	Acute Vision OR Acute Hearing OR Acute Taste and Smell,Alertness,Composed,Imperturbable,Unfazeable,Combat Reflexes,Daredevil,Fearlessness,Fit,Higher Purpose,Intuition,Luck,Magic Resistance,Night Vision,Psionic Resistance,Strong Will,True Faith
				$$disadvs	-25	Bloodlust,Callous,Delusion,Edgy OR Paranoia,Enemy,Flashbacks,Greed,Insomniac,Intolerance,Loner OR Reclusive,Nightmares,Overconfidence,Obsession[Obsession (Hunt Creature)],Post-Combat Shakes,Stubbornness,Vow,Weirdness Magnet,Workaholic
				$$skills	4	Criminology,Research,Streetwise,Tracking,Forensics
				$$skills	10	*Combat/Weapon
				$$skills	4	Occultism,Hidden Lore,Exorcism,Thanatology,Thaumatology,Xenology,Zoology
				$$skills	Stealth=12 OR Shadowing=13
				$$skills	4	Fast-Talk,Interrogation,Intimidation,Performance,Detect Lies
				$$skills	6	First Aid,Scrounging,Armoury,Holdout,Lockpicking,Survival,Traps,Conspiracy Theory

			$$template	Warrior	Space Crew	75	10	12	12	10			7
				$$advs	20	Acceleration Tolerance,Ally Group,Combat Reflexes,Fearlessness,G-Experience,Improved G-Tolerance,Mathematical Ability,Reputation,3D Spatial Sense
				$$disadvs	-15	Chummy OR Gregarious,Code of Honor,Fanaticism,Intolerance,Jealousy,Overconfidence OR Glory Hound,Sense of Duty,Workaholic
				$$skills	Free Fall=13,Vacc Suit=13
				$$select	Specialty	Helmsman/Pilot,Gunner,Sensor Operator,Radioman,Engineer
				$$req	?{Specialty='Helmsman/Pilot'}Skills	Area Knowledge[Area Knowledge (System/Sector)]=13,Astrogation=13,Piloting=14
				$$req	?{Specialty='Gunner'}Skills	Armoury=14,*Gunner,*Gunner
				$$req	?{Specialty='Sensor Operator'}Skills	Cartography=13,Electronics Operation (Sensors)=13,SIGINT Collection/Jamming=13
				$$req	?{Specialty='Radioman'}Skills	Electronics Operation (Communications)=14,Traffic Analysis=14
				$$req	?{Specialty='Engineer'}Skills	Engineer (Vehicle)=12,Shipbuilding (Starship)=12
				$$choose	?{Specialty='Engineer'}Skills	8	*Mechanic
				$$skills	Computer Operation=12,*Guns=14 OR *Beam Weapons=14,Savoir-Faire (Military)=13 OR Streetwise=12 OR Intimidation=12
				$$skills	4	Area Knowledge[Area Knowledge (System/Sector)],First Aid,Scrounging,Administration,Heraldry[Heraldry (Ships' Markings)],Shipbuilding (Starship),Brawling,Carousing

			$$template	Warrior;Rogue	Street Tough	75	11	12	11	11
				$$advs	20	Alertness,Ally Group[Ally Group (Gang)],Combat Reflexes,Contacts[Contact (Police)]=15{Reliability=Somewhat/Frequency=9 or less}
				$$append	Contacts[Contact (Street)]=15{Reliability=Usually/Frequency=12 or less},Danger Sense,Daredevil,High Pain Threshold
				$$append	Luck,Patron,Toughness
				$$disadvs	-20	Addiction,Appearance,Bully,Duty[Duty (Gang)]=12 or less,Callous,Code of Honor,Edgy OR Paranoia,Enemy[Enemy (Rival Gang)],Impulsiveness,Overconfidence,Sense of Duty
				$$append	Semi-Literacy OR Illiteracy,Outlaw,Status,Poverty,Trademark,Uneducated,Unnatural Feature
				$$skills	Area Knowledge[Area Knowledge (City)]=12,Streetwise=12
				$$skills	8	Brawling,Judo,Karate,Knife
				$$skills	4	*Combat/Weapon
				$$skills	Intimidation=11,Survival (Urban)=11
				$$skills	3	Climbing,Filch,Pickpocket,Scrounging,Shadowing,Stealth

			$$template	Warrior	Swordsman	90	11	13	11	11
				$$Advs	#1	Combat Reflexes,Daredevil,Danger Sense,Peripheral Vision,Luck
				$$advs	10	Appearance,Ambidexterity,Charisma,Enhanced Parry,Fit,High Pain Threshold,Toughness
				$$disadvs	-20	Code of Honor,Compulsive Carousing,Enemy,Extravagance,Impulsiveness,Jealousy,Overconfidence OR Glory Hound,Selfish OR Self-Centered,Sense of Duty,Vow=Minor
				$$skills	Broadsword=15 OR Fencing=15 OR Force Sword=15 OR Katana=15 OR Shortsword=15,Fast-Draw[Fast-Draw (Sword)]=14
				$$skills	4	Brawling,Knife,Knife Throwing,Main-Gauche,Karate,Judo
				$$skills	4	Fast-Talk,Intimidation,Savoir-Faire,Streetwise
				$$skills	6	Acrobatics,Climbing,Jumping,Riding,Running
				$$skills	2	Armoury,Body Language,Tactics,Stealth

			$$template	Warrior	Vehicle Crew	75	10	12	12	11			6
				$$advs	20	Alertness,Ally Group[Ally Group (Crew Members)],Combat Reflexes,Fearlessness,Fit,High Pain Threshold,Reputation,Toughness
				$$disadvs	-20	Bloodlust,Callous,Chummy OR Gregarious,Code of Honor,Fanaticism,Hard of hearing,Intolerance,Overconfidence,Post-Combat Shakes,Sense of Duty
				$$req	?{TL<8}Skills	*Guns=15
				$$req	?{TL>7}Skills	*Guns=15 OR *Beam Weapons=15
				$$spec	Specialty	Ground Vehicle Commander	Skills	Driving=12 OR Piloting (Contragravity)=12,Electronics Operation (Communications)=12,*Gunner=14,Orienteering=13,Tactics=13
				$$spec	Specialty	Ground Vehicle Driver	Skills	Driving=14 OR Piloting (Contragravity)=14,*Gunner=14,Orienteering=13
				$$spec	Specialty	Aircraft Pilot	Skills	Piloting=14,Navigation=12,Aviation=12
				$$spec	Specialty	Aircraft Navigator	Skills	Navigation=14,Cartography=13,Piloting=12
				$$spec	Specialty	Gunner	Skills	Armoury=14,*Gunner=15,*Gunner=15
				$$spec	Specialty	Sensor Operator	Skills	Cartography=13,Electronics Operation (Sensors)=13,SIGINT Collection/Jamming=13
				$$spec	Specialty	Communications Operator	Skills	Electronics Operation (Communications)=14,Traffic Analysis=14
				$$Skills	*Mechanic,Savoir-Faire (Military)=12
				$$skills	6	First Aid,Scrounging,Electronics Operation (Communications),Forward Observer,Nuclear-Biological-Chemical Warfare
				$$append	*Survival,Tactics,*Guns,Parachuting,Driving,*Gunner,*Piloting
				$$append	TL>7	*Beam Weapons
			end
		sublist Wizards memlist
			$$wiz(Alchemist, 75, 10, 10, 14, 10)
				$$choose	Advantages	30	Acute Taste and Smell,Literacy,Longevity,Magic Resistance,Patron,Resistant to Poison,Status,Unaging,Wealth
				$$choose	Disadvantages	-30	Absent-Mindedness,Bad Smell,Curious,Greed,Hard of Hearing,Missing Digit,Pyromania,Reclusive,Reputation,Stubbornness
				$$spec	Specialization	Alchemy	Skills	Alchemy=15,Philosophy=14
				$$spec	Specialization	Herbalism	Skills	Botany=14,Herbary=14
				$$choose	Skills	10	Chemistry,Chi Treatment,Distilling,Dyeing,Merchant,Metallurgy,Nei Tan,Pharmacy,Poisons
				$$choose	Skills	4	Astrology,Ancient Egyptian,Greek,Sanskrit,Occultism,Research,Teaching,Thaumatology,Writing
			$$wiz(Apprentice Wizard, 75, 9, 12, 12, 10, "Info.Age=16")
				$$req	Advantages	Literacy,Magery=2,Patron=Powerful Character
				$$req	Disadvantages	Duty=12 or less{Not Dangerous=1},Poverty=Struggling,Youth
				$$choose	Disadvantages	-10	Clueless,Curious,Gluttony,Gullibility,Impulsiveness,Klutz,Low Self-Image,Oblivious,Skinny,Appearance=Unattractive,Unfit
				$$req	Skills	Occultism=12,Thaumatology=12
				$$req	Skills	Research=11,Speed-Reading=11,Writing=11
				$$choose	Skills	#2	Carpentry=11,Cooking=11,Savoir-Faire (Servant),Scrounging
				$$req	Spells	Purify Air,Sense Life,Seek Earth,Ignite Fire,Seek Food,Test Food,Lend Strength
				$$req	Spells	Recover Strength,Share Strength,Simple Illusion,Detect Magic,Find Direction,Measurement
				$$req	Spells	Tell Time,Light,Clean,Restore,Apportation,Banish OR Summon Demon,Seek Plant,Seek Water
			$$wiz(Assassin Wizard, 150, 10, 13, 14, 10)
				$$req	Advantages	Literacy,Magery=3
				$$choose	Advantages	15	Alternate Identity,Wealth,Legal Enforcement Powers,Night Vision,Patron,Reputation=2,Resistant to Poison,Zeroed
				$$choose	Disadvantages	#1	Extremely Hazardous Duty,Secret=Imprisonment or Exile
				$$choose	Disadvantages	-10	Bloodlust,Callous,Loner,Reclusive,No Sense of Humor,Odious Personal Habit,Paranoia
				$$req	Skills	Shadowing=14,Stealth=14
				$$choose	Skills	#1	Blackjack=14,Garrote=14,Knife=14
				$$choose	Skills	2	Blowpipe,Bow,Crossbow,Knife Throwing,Shuriken,Spell Throwing
				$$req	Skills	Streetwise=13
				$$choose	Skills	#1	Armoury=13,Poisons=12,Traps=13
				$$choose	Skills	4	Acting,Camouflage,Climbing,Disguise,Fast-Talk,Forgery,Holdout,Intelligence Analysis,Tracking
				$$req	Spells	Seek Food,Simple Illusion,Seeker,Trace,Clean,Restore,Scryguard,Apportation
				$$spec	Movement	Locksmith	Spells	Lockmaster,Locksmith,Manipulate,Undo
				$$spec	Movement	Teleport	Spells	Flight,Hawk Flight,Levitation,Teleport
				$$req	Spells	Seek Water
				$$spec	Stealth Spells	Invisibility	Spells	Blur,Continual Light,Darkness,Hawk Vision,Invisibility,Light,Night Vision,Keen Eyes
				$$spec	Stealth Spells	Silence	Spells	Keen Ears,Far-Hearing,Hush,Mage-Stealth,Silence,Sound,Sound Vision,Wall of Silence
				$$spec	Attack Spells	Body Control	Spells	Curse-Missile,Deathtouch,Itch,Pain,Paralyze Limb,Spasm,Stun,Wither Limb
				$$spec	Attack Spells	Steal Health	Spells	Decay,Test Food,Lend Health,Lend Strength,Minor Healing,Pestilence,Steal Health,Steal Strength
				$$spec	Attack Spells	Water	Spells	Create Water,Dehydrate,Destroy Water,Ice Dagger,Ice Sphere,Icy Weapon,Purify Water,Shape Water
			$$wiz(Battle Wizard, 150, 11, 13, 13, 11)
				$$req	Advantages	Literacy,Magery=2
				$$choose	Advantages	15	Combat Reflexes,Extra Fatigue,Fit,High Pain Threshold,Military Rank,Rapid Healing,Strong Will,Toughness
				$$choose	Disadvantages	-20	Bad Temper,Berserk,Bloodlust,Bully,Callous,Code of Honor,Duty,Enemy,Overconfidence,Glory Hound
				$$req	Skills	Tactics=12
				$$choose	Skills	10	*Combat/Weapon
				$$spec	Specialization	Armoury, First Aid, Survival	Skills	Armoury=11,First Aid=12,Survival=11
				$$spec	Specialization	Camouflage, Hiking, Stealth	Skills	Camouflage=12,Hiking=10,Stealth=11
				$$spec	Specialization	Boating, Seamanship, Swimming	Skills	Boating=12,Seamanship=12,Swimming=12
				$$spec	Specialization	Engineer, Gunner	Skills	Engineer (Combat)=11,Gunner=14
				$$req	Skills	Savoir-Faire (Military)=12 OR Heraldry=11 OR Intimidation=11 OR Leadership=11 OR Strategy=10
				$$req	Spells	Clumsiness,Itch,Pain,Resist Pain,Spasm
				$$choose	Spells	2	Dexterity,Hinder,Might,Rooted Feet,Tanglefoot
				$$req	Spells	Lend Strength=13,Recover Strength=13
				$$req	Spells	Haste=13,Glue=13 OR Great Haste=13 OR Quick March
				$$req	Spells	Iron Arm=13,Missile Shield,Shield=13,Mystic Mist OR Reverse Missiles
				$$spec	Specialization	Air	Spells	Create Air,Lightning=14,Purify Air=13,Shape Air=13,Stench=13,Walk on Air=13,Whirlwind=13,Windstorm=13
				$$spec	Specialization	Body Control	Spells	Curse-Missile,Deathtouch=15,Paralyze Limb,Stun,Total Paralysis,Wither Limb
				$$spec	Specialization	Earth	Spells	Create Earth,Earth to Stone,Entombment,Flesh to Stone=14,Seek Earth,Shape Earth,Stone Missile=14
				$$spec	Specialization	Fire	Spells	Create Fire,Explosive Fireball,Fireball,Flame Jet=14,Flaming Weapon,Heat,Ignite Fire,Shape Fire
				$$spec	Specialization	Light and Darkness	Spells	Continual Light,Blur,Darkness,Flash=14,Hide,Invisibility=14,Light
				$$spec	Specialization	Mind Control	Spells	Alertness,Daze,Foolishness,Keen Ears,Keen Eyes,Rear Vision,Sleep,Mass Daze=14 OR Mass Sleep=14
				$$spec	Specialization	Movement	Spells	Apportation,Blink,Flight,Hawk Flight,Levitation,Poltergeist,Teleport=13,Winged Knife
				$$spec	Specialization	Sound	Spells	Great Voice,Hush,Mage-Stealth,Silence,Sound,Sound Jet=14,Thunderclap,Voices
				$$spec	Specialization	Water	Spells	Dehydrate=14,Destroy Water,Ice Dagger,Ice Sphere,Purify Water,Seek Water,Shape Water
			$$wiz(Bodyguard Wizard, 100, 10, 11, 13, 10)
				$$req	Advantages	Literacy,Magery=2,Alertness=3 OR Combat Reflexes OR Danger Sense
				$$choose	Disadvantages	-30	!Duty=9 or less,Appearance,Code of Honor,Edgy,Gigantism,Light Sleeper,No Sense of Humor,On the Edge,Selfless,Sense of Duty
				$$req	Skills	Diplomacy=12,Intimidation=12,Shadowing=12
				$$choose	Skills	4	Holdout,Poisons,Traps
				$$choose	Skills	4	Body Language,Criminology,Detect Lies,Interrogation,Streetwise
				$$req	Skills	First Aid=12,Tactics=11
				$$choose	Skills	4	*Combat/Weapon
				$$req	Skills	Savoir-Faire
				$$req	Spells	Purify Air,Hide Thoughts,Sense Emotion,Sense Foes,Truthsayer
				$$req	Spells	Decay,Test Food
				$$req	Spells	Cure Disease,Lend Health,Lend Strength,Major Healing,Minor Healing,Neutralize Poison,Sterilize
				$$req	Spells	Detect Magic
				$$req	Spells	Alertness=12,Keen Ears,Keen Eyes
				$$req	Spells	Missile Shield,Sense Danger,Shield,Watchdog
			$$wiz(Charlatan, 100, 10, 13, 14, 10)
				$$req	Advantages	Luck
				$$choose	Advantages	15	Ally=1{Frequency=15 or less},Autotrance,Charisma,Danger Sense,Double-Jointed,Empathy,Luck,Intuition,Manual Dexterity,Sanctity,Serendipity,Voice
				$$choose	Disadvantages	-30	Compulsive Lying,Delusion[Delusion (I am a wizard)],Enemy[Enemy (Previous victims)],Epilepsy,Greed,Overconfidence,Selfish,Self-Centered,Trickster,Weirdness Magnet
				$$req	Skills	Fast-Talk=14,Psychology=14
				$$choose	Skills	10	Animal Handling=14,Bard=14,Breath Control=14,Disguise=14,Enthrallment (Captivate)=14,Enthrallment (Persuade)=14,Enthrallment (Suggest)=14,Enthrallment (Sway Emotions)=14,Escape=14,Fire Eating=14,Fire Walking=14,Fireworks=14,Fortune Telling=14,Gesture=14,Holdout=14,Hypnotism=14,Intimidation=14,Mechanic[Mechanic (Small Gadgets)]=14,Meditation=14,Performance=14,Scene Design=14,Sleight of Hand=14,Snake Charming=14,Traps=14,Ventriloquism=14
				$$req	Skills	Acting=13
				$$choose	Skills	4	Animal Handling=12,Bard=12,Breath Control=12,Disguise=12,Enthrallment (Captivate)=12,Enthrallment (Persuade)=12,Enthrallment (Suggest)=12,Enthrallment (Sway Emotions)=12,Escape=12,Fire Eating=12,Fire Walking=12,Fireworks=12,Fortune Telling=12,Gesture=12,Holdout=12,Hypnotism=12,Intimidation=12,Mechanic[Mechanic (Small Gadgets)]=12,Meditation=12,Performance=12,Scene Design=12,Sleight of Hand=12,Snake Charming=12,Traps=12,Ventriloquism=12
				$$choose	Skills	4	Animal Handling=11,Bard=11,Breath Control=11,Disguise=11,Enthrallment (Captivate)=11,Enthrallment (Persuade)=11,Enthrallment (Suggest)=11,Enthrallment (Sway Emotions)=11,Escape=11,Fire Eating=11,Fire Walking=11,Fireworks=11,Fortune Telling=11,Gesture=11,Holdout=11,Hypnotism=11,Intimidation=11,Mechanic[Mechanic (Small Gadgets)]=11,Meditation=11,Performance=11,Scene Design=11,Sleight of Hand=11,Snake Charming=11,Traps=11,Ventriloquism=11

			# Demon is really too open-ended to wedge into a template

			$$wiz(Druid, 100, 10, 10, 15, 10)
				$$req	Advantages	Literacy,Power Investiture=1
				$$choose	Advantages	15	Animal Empathy,Beast-Kin,Clerical Investment,Common Sense,Faerie Empathy,Intuition,Plant Empathy,Tree-Kin,Power Investiture,Reputation,Status
				$$req	Disadvantages	Sense of Duty[Sense of Duty (Nature)]=3
				$$choose	Disadvantages	-15	Age,Fear of Crowds,Intolerance[Intolerance (Religious)],Odious Personal Habit[Odious Personal Habit (Arcane and mysterious)],Primitive,Fear of Machinery,Vow[Vow (Always live outdoors)]=Major
				$$req	Skills	Naturalist=14,Sacrifice=14,Theology=14,Bard=13,Occultism=13,Teaching=13,Meteorology[Weather Sense]=13
				$$choose	Skills	#2	Gardening=14,Agronomy=13,Hidden Lore[Hidden Lore (Faerie Lore)]=13,Animal Handling,Astrology=12,Bardic Lore=12,Botany=12,Geology=12,History=12,Veterinary=12,Zoology=12
				$$req	Spells	Beast Link,Beast-Soother,Beast Speech,Beast Summoning,Master,Rider Within,*Shapeshifting
				$$choose	Spells	#2	Bird Control,Fish Control,Insect Control,Mammal Control,Mollusk Control,Reptile Control
				$$req	Spells	Persuasion=14,Sense Emotion=14,Sense Foes=14,Sense Life=14,Seek Earth=14,Shape Earth=14,Bless Plants,Forest Warning,Heal Plant,Hide Path,Identify Plant,Plant Growth,Seek Plant,Shape Plant,Tangle Growth,Purify Water=14,Seek Water=14
			$$wiz(Elementalist Wizard, 100, 9, 10, 14, 11)
				$$req	Advantages	Literacy,Longevity
				$$req	Disadvantages	Reduced Hit Points=2
				$$select	Element	Fire Mage,Earth Mage,Water Mage,Air Mage,Asian Wizard,Classical/European Wizard

				$$req	?{Element='Asian Wizard' or Element='Classical/European Wizard'}Advantages	Magery=2
				$$req	?{Element='Air Mage'}Advantages	Magery: One College=3{College=Air}
				$$req	?{Element='Fire Mage'}Advantages	Magery: One College=3{College=Fire}
				$$req	?{Element='Water Mage'}Advantages	Magery: One College=3{College=Water}
				$$req	?{Element='Earth Mage'}Advantages	Magery: One College=3{College=Earth}

				$$req	?{Element='Asian Wizard' or Element='Classical/European Wizard'}Disadvantages	Disciplines of Faith,Odious Personal Habit[Odious Personal Habit (Babbling philosopher)]=Bad
				$$req	?{Element='Earth Mage'}Disadvantages	Hidebound,Stubbornness
				$$req	?{Element='Air Mage'}Disadvantages	Short Attention Span
				$$req	?{Element='Fire Mage'}Disadvantages	Bad Temper
				$$req	?{Element='Water Mage'}Disadvantages	Impulsiveness
				$$req	Skills	Alchemy=13,Philosophy=13,Astrology=12,Occultism=12,Physics=12,Physiology=11
				$$choose	Skills	#1	Diagnosis=11,Yin/Yang Healing=11
				$$req	?{Element='Asian Wizard'}Spells	Create Earth=14,Earth to Stone=14,Seek Earth=14,Shape Earth=14,Shape Stone=14,Create Fire=14,Extinguish Fire=14,Ignite Fire=14,Shape Fire=14,Body of Metal=13,Identify Metal=14,Metal Vision=14,Shape Metal=14,Heal Plant=14,Identify Plant=14,Plant Growth=14,Seek Plant=14,Create Water=14,Purify Water=14,Seek Water=14,Shape Water=14,Note[Choose 4 points in other spells]
				$$req	?{Element='Classical/European Wizard'}Spells	Earth to Air=14,Earth to Stone=14,Seek Earth=14,Shape Earth=14,Stone to Earth=14,Breathe Water=14,Create Air=14,Predict Weather=14,Purify Air=14,Shape Air=14,Cold=14,Create Fire=14,Heat=14,Ignite Fire=14,Shape Fire=14,Create Water=14,Destroy Water=14,Purify Water=14,Seek Water=14,Shape Water=14,Note[Choose 5 points in other spells]
				$$req	?{Element='Earth Mage'}Spells	Body of Stone=15,Control Earth Elemental=15,Create Earth=15,Create Earth Elemental=15,Earth to Stone=15,Earth Vision=15,Earthquake=15,Entombment=15,Flesh to Stone=15,Sand Jet=15,Seek Earth=15,Shape Earth=15,Shape Stone=15,Stone Missile=15,Stone to Earth=15,Stone to Flesh=15,Summon Earth Elemental=15,Walk Through Earth=15,Note[Distribute 10 points among above spells]
				$$req	?{Element='Air Mage'}Spells	Air Jet=15,Body of Air=15,Control Air Elemental=15,Create Air=15,Create Air Elemental=15,Destroy Air=15,Lightning=15,No-Smell=15,Odor=15,Predict Weather=15,Purify Air=15,Shape Air=15,Stench=15,Summon Air Elemental=15,Walk on Air=15,Whirlwind=15,Windstorm=15,Note[Distribute 11 points among above spells]
				$$req	?{Element='Fire Mage'}Spells	Breathe Fire=14,Cold=15,Control Fire Elemental=15,Create Fire=15,Create Fire Elemental=15,Essential Flame=15,Explosive Fireball=15,Extinguish Fire=15,Fireball=15,Fireproof=15,Flame Jet=15,Flaming Missiles=15,Flaming Weapon=15,Heat=15,Ignite Fire=15,Phantom Flame=15,Resist Cold=15,Resist Fire=15,Shape Fire=15,Summon Fire Elemental=15,Note[Distribute 8 points among above spells]
				$$req	?{Element='Water Mage'}Spells	Body of Water=15,Control Water Elemental=15,Create Water=15,Create Water Elemental=15,Dehydrate=15,Destroy Water=15,Essential Water=15,Fog=15,Freeze=15,Frost=15,Frostbite=15,Ice Dagger=15,Ice Slick=15,Ice Sphere=15,Ice Vision=15,Icy Weapon=15,Melt Ice=15,Purify Water=15,Seek Water=15,Shape Water=15,Snow Shoes=15,Summon Water Elemental=15,Umbrella=15,Walk on Water=15,Water Jet=15,Water Vision=15,Note[Distribute 2 points among above spells]
			$$wiz(Enchanter, 100, 9, 10, 14, 10)
				$$req	Advantages	Literacy,Magery=3
				$$choose	Advantages	20	Ally Group[Ally Group (Apprentices)],Ally Group[Ally Group (Circle)],Contacts[Contacts (Business)],Extra Fatigue,Fit,Patron[Patron (Enchanters' Guild)]=Powerful Group,Reputation,Single-Minded,Status,Versatile,Wealth
				$$choose	Disadvantages	-30	Absent-Mindedness,Age,*Bad Sight,Combat Paralysis,Duty=12 or less{Not Dangerous=5},Extravagance,Greed,Hard of Hearing,Klutz,Low Pain Threshold,Miserliness,Post-Combat Shakes,Workaholic
				$$req	Skills	Merchant=14,Thaumatology=14,Accounting=12,Economics=12
				$$choose	Skills	2	Occultism,Research,Teaching,Writing
				$$req	Skills	Alchemy=10,Rune-Lore=10
				$$req	Spells	Enchant=15,Powerstone=15,Scroll=15,Staff=15,Lend Strength=15,Recover Strength=15,Share Strength=15,Analyze Magic=15,Detect Magic=15,Identify Spell=15,Conceal Magic=15,Delay=15,Link=15,Magic Resistance=15,Scryguard=15
				$$choose	Spells	#6	Purify Air=15,Climbing=15,Curse-Missile=15,Itch=15,Fatigue=15,Might=15,Sense Foes=15,Sense Life=15,Seek Earth=15,Ignite Fire=15,Seek Food=15,Test Food=15,Simple Illusion=15,Light=15,Foolishness=15,Keen Ears=15,Keen Eyes=15,Keen Nose=15,Apportation=15,Haste=15,Death Vision=15,Seek Plant=15,Magelock=15,Shield=15,Sound=15,Seek Water=15

				# These are obviously to satisfy the 10-college requirement, so you're meant
				# to choose one from each of 6 colleges, but I don't see an easy way to 
				# implement that restriction.

			$$wiz(Healer, 100, 10, 10, 15, 10)
				$$choose	Advantages	#1	Magery=2,Power Investiture=2
				$$choose	Advantages	15	Disease-Resistant,Empathy,Extra Fatigue,Fit,Immunity to Disease,Less Sleep,Literacy,Longevity,Rapid Healing,Sensitive,Strong Will
				$$choose	Disadvantages	-30	Addiction,Charitable,Guilt Complex,Insomniac,Nightmares,*Pacifism,Selfless,Sense of Duty,Workaholic
				$$req	Skills	Diagnosis=14,Physician=14
				$$spec	Specialization	Alchemy	Skills	Alchemy=13
				$$spec	Specialization	Botany and Herbary	Skills	Botany=13,Herbary=12
				$$spec	Specialization	Pharmacy	Skills	Pharmacy=14
				$$choose	Skills	#2	MA Skill[Hairdressing]=14,Tattooing=14,Chi Treatment=13,Hypnotism=13,Poisons=13,Psychology=13,Yin/Yang Healing=13,Physiology=12,Surgery=12
				$$choose	Skills	#2	Beverage-Making=14,Cooking=14,Distilling=13,Theology=12
				$$req	Spells	Decay=15,Test Food=15,Awaken=15,Cure Disease=15,Lend Health=15,Lend Strength=15,Major Healing=15,Minor Healing=15,Neutralize Poison=15,Recover Strength=15,Regeneration=14,Restoration=14,Sterilize=15,Suspended Animation=15,Daze=15,Foolishness=15,Peaceful Sleep=15,Sleep=15,Silence=15,Sound=15

			$$wiz(Illusionist, 100, 10, 12, 14, 10)
				$$req	Advantages	Literacy,Magery=2
				$$choose	Disadvantages	-25	Compulsive Lying,Flashbacks,Greed,Impulsiveness,Kleptomania,No Reflection,No Shadow,Overconfidence,Reputation,Trickster,Unnatural Feature,Voices
				$$req	Skills	Illusion Art=14
				$$spec	Specialization	Acting and Fast-Talk	Skills	Acting=14,Fast-Talk=14
				$$spec	Specialization	Bard and Performance	Skills	Bard=14,Performance=14
				$$spec	Specialization	Combat/Weapon	Skills	4:*Combat/Weapon
				$$req	Skills	Camouflage=13,Disguise=12,Stealth=12
				$$choose	Skills	2	Acrobatics,Bard,Dancing,Filch,Forgery,Gambling,Holdout,Hypnotism,Juggling,Make-Up,*Mimicry,Scene Design,Sleight of Hand,Traps,Ventriloquism
				$$req	Spells	Phantom Flame=14,Complex Illusion=14,Control Illusion=14,Dispel Illusion=14,Illusion Disguise=14,Illusion Shell=14,Independence=14,Know Illusion=14,Perfect Illusion=14,Simple Illusion=14,Restore=14,Sound=14

			# The various Improvisers are really too open-ended to wedge into a template
			# Knack wizard is too open-ended, but the enhancements
			# at the end of this file

			$$wiz(Law Enforcer Wizard, 125, 11, 11, 13, 11)
				$$req	Advantages	Legal Enforcement Powers=Local,Literacy,Magery=1
				$$choose	Advantages	20	Alertness,Intuition,Legal Immunity,Reputation,Legal Enforcement Powers,Magery
				$$choose	Disadvantages	-30	!Duty,Pacifism (Cannot Harm Innocents),Charitable,Curious,Honesty,Intolerance[Intolerance (Criminals)]=Specific,Odious Personal Habit[Odious Personal Habit (Authoritarian)],Secret[Secret (On the Take)]=Utter Rejection,Sense of Duty,Workaholic
				$$req	Skills	Area Knowledge[Area Knowledge (Beat)]=12,Detect Lies=12,Interrogation=12,MA Skill[Law Enforcement]=13
				$$choose	Skills	6	*Combat/Weapon,Tactics
				$$req	Skills	Holdout=11,Law=11
				$$choose	Skills	2	Diplomacy,Intimidation,Streetwise
				$$req	Skills	First Aid=12,Stealth=10
				$$choose	Skills	#1	Criminology=11,Forensics=10
				$$choose	Skills	#1	Riding (Horse)=10,Running=9
				$$req	Spells	Beast-Soother,Hinder,Rooted Feet,Mind-Reading,Mind-Sending,Persuasion,Sense Emotion,Sense Foes,Truthsayer,Seek Earth,Know Illusion,Simple Illusion,Analyze Magic,Aura,Detect Magic,History,Identify Spell,See Secrets,Seeker,Trace,Dark Vision,Infravision,Light,See Invisible,Keen Eyes,Haste,Seek Water
			$$wiz(Martial Artist Wizard, 150, 11, 13, 13, 11, , , , , , , , GURPSMartialArts.cds)
				$$req	Advantages	Magery=2
				$$choose	Advantages	15	Combat Reflexes,Enhanced Block,Enhanced Dodge,Enhanced Parry,High Pain Threshold,Iron Hand,Patron[Patron (Master)],Strong Will,Style Familiarity,Toughness=1
				$$choose	Disadvantages	-30	Code of Honor,Disciplines of Faith[Disciplines of Faith (Asceticism)]=Asceticism,Disciplines of Faith[Disciplines of Faith (Monasticism)]=Monasticism,Duty[Duty (To Master)],Obsession[Obsession (Become a master)]=2,Pacifism (Cannot Harm Innocents),Pacifism (Cannot Kill),Pacifism (Self-Defense Only),Poverty[Poverty (Struggling)]=Struggling,Poverty[Poverty (Poor)]=Poor,Vow[Vow (Never use weapons)]=Great
				$$choose	Skills	20	*Martial Arts Style,*Combat/Weapon,*Martial Arts Maneuver
				$$choose	Skills	#2	Armoury=12,Leadership=12,Teaching=12,Style Analysis=11,Tactics=11,Meditation=10,Physiology=10,Sensitivity=10,Body Sense=11
				$$req	Spells	Purify Air=13,Deathtouch=13,Itch=13,Might=13,Pain=13,Paralyze Limb=13,Resist Pain=13,Spasm=13,Strike Blind=13,Stun=13,Wither Limb=13,Seek Earth=13,Ignite Fire=13,Lend Health=13,Lend Strength=13,Minor Healing=13,Blur=13,Continual Light=13,Darkness=13,Hide=13,Infravision=13,Invisibility=13,Light=13,Find Weakness=13,Weaken=13,Keen Ears=13,Great Haste=12,Haste=13,Iron Arm=13,Missile Shield=13,Shield=13,Hush=13,Mage-Stealth=13,Silence=13,Sound=13,Sound Vision=13,Thunderclap=13,Seek Water=13
			$$wiz(Necromancer, 250, 9, 10, 15, 13)
				$$req	Advantages	Literacy,Magery=3,Strong Will=2
				$$choose	Advantages	30	Status,Wealth
				$$req	Disadvantages	Secret=Imprisonment or Exile
				$$choose	Disadvantages	-10	Bloodlust,Megalomania,Odious Personal Habit[Odious Personal Habit (No respect for the dead)],Curious,Oblivious,Appearance,Bad Smell,Disturbing Voice,Excommunicated,Unnatural Feature,Reclusive,Frightens Animals,Lifebane
				$$req	Skills	Alchemy=16,Occultism=15,Research=15,Thanatology=15,Thaumatology=16,Theology=15,Archaeology=14
				#req	Skills	Language (MA)[Language (Three)]=14,Language (MA)[Language (Obscure)]=14,Language (MA)[Language (Languages)]=14
				$$choose	Skills	#3	*Language=14
				$$req	Skills	Poisons=12,Writing=13
				$$req	Spells	Seek Earth=16,Shape Earth=16,Decay=16,Test Food=16,Cure Disease=16,Halt Aging=15,Lend Health=16,Lend Strength=16,Major Healing=15,Minor Healing=16,Recover Strength=16,Restoration=15,Sterilize=16,Youth=15,Ancient History=16,Detect Magic=16,History=16,Seeker=16,Trace=16,Counterspell=16,Curse=16,Dispel Magic=16,Magic Resistance=16,Pentagram=18,Scryguard=16,Spell Shield=16
				$$req	Spells	Age=15,Banish=16,Control Zombie=16,Death Vision=16,Pestilence=16,Sense Spirit=16,Skull-Spirit=16,Soul Jar=15,Steal Health=16,Steal Strength=16,Steal Youth=15,Summon Demon=16,Summon Spirit=16,Turn Zombie=16,Zombie=16,Purify Water=16,Seek Water=16
			$$wiz(Overlord Wizard, 450, 10, 10, 20, 12)
				$$req	Advantages	Literacy,Magery=3,Strong Will=3
				$$choose	Advantages	140	Administrative Rank,Ally Group,Appearance,Charisma,Clerical Investment,Legal Enforcement Powers,Military Rank,Multimillionaire,Reputation,Status,Voice,Wealth
				$$choose	Disadvantages	-30	Charitable,Compulsive Generosity,Duty,Enemy,Excommunicated,Fanaticism,Greed,Honesty,Intolerance,Jealousy,Paranoia,Selfish,Sense of Duty[Sense of Duty (His People)]=2
				$$req	Skills	Administration=20,Area Knowledge[Area Knowledge (His Domain)]=20,Bard=20,Intimidation=20,Leadership=20,Savoir-Faire,Diplomacy=18
				$$choose	Skills	8	Economics,Intelligence Analysis,Law,Politics,Psychology,Strategy,Tactics,Theology
				$$choose	Skills	6	Alchemy,Chess,Falconry,History,Philosophy,Riding,*Combat/Weapon
				$$req	Spells	Hide Thoughts=21,Mind-Reading=21,Mind-Sending=21,Persuasion=21,Sense Emotion=21,Sense Foes=21,Telepathy=20,Truthsayer=21,Seek Earth=21,Enchant=20,Test Food=21,Lend Strength=21,Recover Strength=21,Know Illusion=21,Simple Illusion=21,History=21,Seeker=21,Trace=21,Wizard Eye=21,Hawk Vision=21,Counterspell=21,Dispel Magic=21,Bravery=21,Fear=21,Keen Eyes=21,Panic=21,Apportation=21,Levitation,Flight,Hawk Flight,Teleport=20
				$$req	Spells	Banish=21,Planar Summons=21,Mystic Mist=21,Shield=21,Great Voice=21,Sound=21,Thunderclap=21,Voices=21,Seek Water=21
				$$spec	First Specialty	Air/Water	Spells	Clouds=21,Create Air=21,Purify Air=21,Rain=21,Shape Air=21,Whirlwind=21,Windstorm=21,Create Water=21,Frost=21,Hail=21,Purify Water=21,Shape Water=21,Snow=21
				$$spec	First Specialty	Earth/Fire	Spells	Earth to Stone=21,Earth Vision=21,Earthquake=21,Shape Earth=21,Shape Stone=21,Stone to Earth=21,Volcano=21,Create Fire=21,Extinguish Fire=21,Fireproof=21,Ignite Fire=21,Phantom Flame=21,Shape Fire=21
				$$spec	First Specialty	Enchantment	Spells	Great Wish,Hex=21,Lesser Wish=20,Limit=21,Name=21,Password=21,Power=21,Powerstone=21,Remove Enchantment=21,Scroll=21,Staff=21,Suspend Enchantment=21,Wish=20
				$$spec	First Specialty	Necromantic	Spells	Decay=21,Lend Health=21,Minor Healing=21,Death Vision=21,Pestilence=21,Skull-Spirit=21,Soul Jar=20,Steal Health=21,Steal Strength=21,Summon Demon=21,Summon Shade=20,Summon Spirit=21,Zombie=21
				$$spec	First Specialty	Meta-Spells	Spells	Bless=21,Curse=21,Delay=21,Drain Mana=21,Link=21,Magic Resistance=21,Pentagram=21,Remove Curse=21,Restore Mana=21,Scryguard=21,Scrywall=21,Spell Shield=21,Ward=21
				$$spec	First Specialty	Mind Control	Spells	Charm=21,Emotion Control=21,Enslave=20,False Memory=21,Foolishness=21,Forgetfulness=21,Great Geas=20,Lesser Geas=20,Loyalty=21,Mass Suggestion=21,Suggestion=21,Terror=21,Wisdom=21
				$$spec	First Specialty	Plant	Spells	Animate Plant=21,Bless Plants=21,Create Plant=21,Forest Warning=21,Heal Plant=21,Hide Path=21,Identify Plant=21,Plant Growth=21,Plant Sense=21,Seek Plant=21,Shape Plant=21,Tangle Growth=21,Wither Plant=21
				$$spec	Second Specialty	Air/Water	Spells	Clouds=21,Create Air=21,Purify Air=21,Rain=21,Shape Air=21,Whirlwind=21,Windstorm=21,Create Water=21,Frost=21,Hail=21,Purify Water=21,Shape Water=21,Snow=21
				$$spec	Second Specialty	Earth/Fire	Spells	Earth to Stone=21,Earth Vision=21,Earthquake=21,Shape Earth=21,Shape Stone=21,Stone to Earth=21,Volcano=21,Create Fire=21,Extinguish Fire=21,Fireproof=21,Ignite Fire=21,Phantom Flame=21,Shape Fire=21
				$$spec	Second Specialty	Enchantment	Spells	Great Wish,Hex=21,Lesser Wish=20,Limit=21,Name=21,Password=21,Power=21,Powerstone=21,Remove Enchantment=21,Scroll=21,Staff=21,Suspend Enchantment=21,Wish=20
				$$spec	Second Specialty	Necromantic	Spells	Decay=21,Lend Health=21,Minor Healing=21,Death Vision=21,Pestilence=21,Skull-Spirit=21,Soul Jar=20,Steal Health=21,Steal Strength=21,Summon Demon=21,Summon Shade=20,Summon Spirit=21,Zombie=21
				$$spec	Second Specialty	Meta-Spells	Spells	Bless=21,Curse=21,Delay=21,Drain Mana=21,Link=21,Magic Resistance=21,Pentagram=21,Remove Curse=21,Restore Mana=21,Scryguard=21,Scrywall=21,Spell Shield=21,Ward=21
				$$spec	Second Specialty	Mind Control	Spells	Charm=21,Emotion Control=21,Enslave=20,False Memory=21,Foolishness=21,Forgetfulness=21,Great Geas=20,Lesser Geas=20,Loyalty=21,Mass Suggestion=21,Suggestion=21,Terror=21,Wisdom=21
				$$spec	Second Specialty	Plant	Spells	Animate Plant=21,Bless Plants=21,Create Plant=21,Forest Warning=21,Heal Plant=21,Hide Path=21,Identify Plant=21,Plant Growth=21,Plant Sense=21,Seek Plant=21,Shape Plant=21,Tangle Growth=21,Wither Plant=21
			$$wiz(Priest, 100, 10, 10, 14, 10)
				$$req	Advantages	Clerical Investment=1,Literacy,Power Investiture=1
				$$choose	Advantages	15	Blessed,Charisma,Clerical Investment,Divine Favor,Legal Immunity,Luck,Oracle,Patron (Church),Pious,Power Investiture,Status,Strong Will,True Faith,Voice
				$$req	Disadvantages	Duty[Duty (To church)]=12 or less{Not Dangerous=5}
				$$choose	Disadvantages	-5	Code of Honor,*Disciplines of Faith,Sense of Duty,Vow
				$$choose	Disadvantages	-20	Code of Honor,*Disciplines of Faith,Sense of Duty,Vow,Charitable,Fanaticism,Honesty,Intolerance[Intolerance (Religious)],*Pacifism,Poverty,Stubbornness,Truthfulness
				$$req	Skills	Performance/Ritual=14,Theology=14
				$$choose	Skills	10	Bard,Fast-Talk,Occultism,Teaching,Astrology,Detect Lies,Diplomacy,Exorcism,Philosophy,Psychology,Sacrifice
				$$choose	Skills	5	Singing,Fire Walking,First Aid,Dancing,Administration,Leadership,Politics,Research,Writing,Diagnosis,Law[Law (Religious)],Musical Instrument,Physician,Thanatology,Meditation
				$$req	Spells	Note[Choose 24 points of spells from the god's spell list]
			$$wiz(Psionic Wizard, 100, 10, 10, 14, 10, , , , , , , , GURPSPsionics.cds)
				$$choose	Powers	50	*Psionics,Advantages::Animal Empathy,Advantages::Autotrance,Advantages::Charisma,Advantages::Medium,Advantages::Mindlink,Advantages::Plant Empathy,Advantages::Special Rapport,Advantages::Strong Will,Advantages::Visualization
				$$choose	Disadvantages	-30	Epilepsy,Migraine,Nightmares,Sleepwalker,Weirdness Magnet,Quirk[Special Effect],Generic Disadvantage[Drawback],Delusion[Delusion (My powers are magical)]=Major,Supersensitive,Telepathic Addiction
				$$req	Skills	Psionics
				$$choose	Skills	6	Lucid Dreaming=14,Mind Block=14,Autohypnosis=13,Body Language=13,Detect Lies=13,Hypnotism=13,Dreaming=12,Meditation=12,Sensitivity=12,Flight=10,Body Sense=10
				$$choose	Skills	#2	Occultism=12,Research=12,Teaching=12,Writing=12,Psychology=11
				$$req	Skills	Note[Choose 20 points of psionic skills]

			$$wiz	Ritual Magician	90	10	10	15	10			3		Standard	100	40	GURPSSpirits.mds
				$$req	Additional Attributes	Ritual Modifier
				$$req	Advantages	Ritual Aptitude=5
				$$choose	Advantages	20	Ally Group[Ally Group (Followers)]=1{Point Level=75/Frequency=9 or less},Autotrance,Channelling,Clerical Investment=1,Intuition,Luck=1,Mystic Symbol=1,Reawakened,Reputation=1{Recognized by=Everyone/Frequency of Recognition=All the time},Spirit Advisor{Frequency of Appearance=Rarely (6 or less)},Spirit Empathy,Status=1,Strong Will=1,Visualization
				$$choose	Disadvantages	-30	Disciplines of Faith=1,Duty=1,Fanaticism,Intolerance=1,Reputation=1{Recognized by=Everyone/Frequency of Recognition=All the time},Secret=1,Sense of Duty=1,Social Stigma=1,Voices=1,Vow=1
				$$req	Skills	Ritual Magic=15,Symbol Drawing=14
				$$choose	Skills	4	Occultism,Theology
				$$choose	Skills	#1	First Aid,Bard,Performance,Performance/Ritual,Musical Instrument,Poisons,Dancing
				$$choose	Skills	#2	Path of Cunning=14,Path of Dreams=14,Path of Health=14,Path of Knowledge=14,Path of Luck=14,Path of Nature=14,Path of Protection=14,Path of Spirit=14
				$$req	Skills	Note[Rituals: 12 points]

			$$wiz(Rune-Mage, 100, 10, 10, 15, 10)
				$$req	Advantages	Literacy,Magery=1,Manual Dexterity=2
				$$choose	Disadvantages	-25	Destiny,*Disciplines of Faith,Cursed (Divine Curse),Obsession[Obsession (Obtain a full set of true rune stones)],Unluckiness,Vow[Vow (Never learn any magic but rune magic)]=Great,Weirdness Magnet
				$$req	Skills	Rune-Lore=15,Calligraphy=13
				$$choose	Skills	4	*Artistic,*Craft
				$$req	Skills	Occultism=13,Writing=13
				$$req	Spells	Activate Runes=15
				$$choose	Skills	#7	Rune: Food=15,Rune: Sound=15,Rune: Air=14,Rune: Fire=14,Rune: Illusion=14,Rune: Light/Dark=14,Rune: Plant=14,Rune: Water=14,Rune: Animal=13,Rune: Body (Man)=13,Rune: Earth=13,Rune: Magic=13,Rune: Mind=13,Rune: Undead (Spirit)=13
				$$choose	Skills	#6	Rune: Communicate=14,Rune: Move=14,Rune: Protect=14,Rune: Strengthen=14,Rune: Warn=14,Rune: Weaken=14,Rune: Control=13,Rune: Create=13,Rune: Heal=13,Rune: Sense=13,Rune: Transform=13
			$$wiz(Seer, 100, 10, 10, 14, 10)
				$$req	Advantages	Literacy
				$$spec	Specialization	Mage	Advantages	Magery=1
				$$spec	Specialization	Priest	Advantages	Clerical Investment=1,Power Investiture=1
				$$choose	Advantages	#1	Awareness=Detect Paranormal,Danger Sense,Intuition,Luck=Born Lucky,Oracle,Racial Memory=Passive,Serendipity=Once per session
				$$choose	Disadvantages	-20	Addiction[Addiction (Hallucinogen)]{Incapacitating or Hallucinogenic=-10},Code of Honor,Delusion,*Disciplines of Faith,Flashbacks,Manic-Depressive,Nightmares,Paranoia,Sense of Duty,Truthfulness,Voices,Vow
				$$choose	Skills	#1	Astrology=14,Augury=13,Dreaming=13,Rune-Lore=13
				$$choose	Skills	#1	Bard=13,Writing=13
				$$choose	Skills	#1	Occultism=13,Philosophy=12,Thaumatology=11,Theology=12
				$$choose	Skills	#1	Fast-Talk=13,Fortune Telling=13,Gambling=13,Research=13,Meteorology[Weather Sense]=13
				$$req	Spells	Seek Earth=13,History=13,Seeker=13,Trace=13,Seek Water=13
				$$spec	Specialization	Aeromancy	Spells	Divination (Aeromancy)=13,Purify Air=13,Create Air=13,Shape Air=13,Destroy Air=13,Predict Weather=13,Walk on Air=13,Lightning=13,Body of Air=13,Windstorm=13,Whirlwind=13
				$$spec	Specialization	Arithmancy	Spells	Divination (Arithmancy)=13,Purify Air=13,Create Air=13,Shape Air=13,Destroy Air=13,Predict Weather=13,Walk on Air=13,Lightning=13,Body of Air=13
				$$spec	Specialization	Astragyromancy	Spells	Divination (Astragyromancy)=13,Purify Air=13,Create Air=13,Shape Air=13,Destroy Air=13,Predict Weather=13,Walk on Air=13,Shape Earth=13,Earth Vision=13,Earth to Stone=13,Stone to Earth=13,Shape Stone=13,Ignite Fire=13,Create Fire=13,Shape Fire=13,Extinguish Fire=13,Heat=13,Cold=13,Purify Water=13,Create Water=13,Destroy Water=13,Shape Water=13,Ice Sphere=13
				$$spec	Specialization	Astrology	Spells	Divination (Astrology)=13,Purify Air=13,Create Air=13,Shape Air=13,Destroy Air=13,Predict Weather=13,Walk on Air=13,Lightning=13,Body of Air=13,Windstorm=13,Whirlwind=13
				$$spec	Specialization	Cartomancy	Spells	Divination (Cartomancy)=13,Purify Air=13,Create Air=13,Shape Air=13,Shape Earth=13,Earth Vision=13,Ignite Fire=13,Create Fire=13,Shape Fire=13,Purify Water=13,Create Water=13
				$$spec	Specialization	Chiromancy	Spells	Divination (Chiromancy)=13,Purify Air=13,Create Air=13,Shape Air=13,Destroy Air=13,Shape Earth=13,Earth Vision=13,Earth to Stone=13,Ignite Fire=13,Create Fire=13,Shape Fire=13,Extinguish Fire=13,Purify Water=13,Create Water=13,Destroy Water=13
				$$spec	Specialization	Crystal-Gazing	Spells	Divination (Crystal-Gazing)=13,Shape Earth=13,Earth Vision=13,Earth to Stone=13,Stone to Earth=13,Purify Water=13,Create Water=13,Destroy Water=13,Shape Water=13
				$$spec	Specialization	Dactylomancy	Spells	Divination (Dactylomancy)=13,Purify Air=13,Create Air=13,Shape Air=13,Shape Earth=13,Earth Vision=13,Ignite Fire=13,Create Fire=13,Shape Fire=13,Purify Water=13,Create Water=13
				$$spec	Specialization	Geomancy	Spells	Divination (Geomancy)=13,Shape Earth=13,Earth Vision=13,Earth to Stone=13,Stone to Earth=13,Shape Stone=13,Create Earth=13,Stone Missile=13,Walk Through Earth=13,Flesh to Stone=13
				$$spec	Specialization	Graphology	Spells	Divination (Graphology)=13,Purify Air=13,Create Air=13,Shape Air=13,Destroy Air=13,Predict Weather=13,Walk on Air=13,Shape Earth=13,Earth Vision=13,Earth to Stone=13,Stone to Earth=13,Shape Stone=13
				$$spec	Specialization	Haruspication	Spells	Divination (Haruspication)=13,Shape Earth=13,Earth Vision=13,Earth to Stone=13,Stone to Earth=13,Shape Stone=13,Create Earth=13,Stone Missile=13,Walk Through Earth=13,Flesh to Stone=13
				$$spec	Specialization	Hydromancy	Spells	Divination (Hydromancy)=13,Purify Water=13,Create Water=13,Destroy Water=13,Shape Water=13,Ice Sphere=13,Essential Water=13,Walk on Water=13,Body of Water=13,Dehydrate=13
				$$spec	Specialization	Libranomancy (General)	Spells	Divination (Libranomancy)=13,Purify Air=13,Create Air=13,Shape Air=13,Destroy Air=13,Predict Weather=13,Shape Earth=13,Earth Vision=13,Earth to Stone=13,Stone to Earth=13,Ignite Fire=13,Create Fire=13,Shape Fire=13,Extinguish Fire=13,Heat=13,Purify Water=13,Create Water=13,Destroy Water=13,Shape Water=13
				$$spec	Specialization	Libranomancy (Air/Fire)	Spells	Divination (Libranomancy)=13,Purify Air=13,Create Air=13,Shape Air=13,Destroy Air=13,Predict Weather=13,Walk on Air=13,Lightning=13,Ignite Fire=13,Create Fire=13,Shape Fire=13,Extinguish Fire=13,Heat=13,Cold=13,Essential Flame=13
				$$spec	Specialization	Lithomancy	Spells	Divination (Lithomancy)=13,Shape Earth=13,Earth Vision=13,Earth to Stone=13,Stone to Earth=13,Purify Water=13
				$$spec	Specialization	Lunomancy	Spells	Divination (Lunomancy)=13,Purify Air=13,Create Air=13,Shape Air=13,Destroy Air=13,Shape Earth=13
				$$spec	Specialization	Molybdomancy	Spells	Divination (Molybdomancy)=13,Ignite Fire=13,Create Fire=13,Shape Fire=13,Extinguish Fire=13,Heat=13,Purify Water=13,Create Water=13,Destroy Water=13,Shape Water=13
				$$spec	Specialization	Oneiromancy	Spells	Divination (Oneiromancy)=13,Purify Air=13,Create Air=13,Shape Air=13,Destroy Air=13,Predict Weather=13,Purify Water=13,Create Water=13,Destroy Water=13,Shape Water=13
				$$spec	Specialization	Pedomancy	Spells	Divination (Pedomancy)=13,Shape Earth=13,Earth Vision=13,Earth to Stone=13,Purify Water=13
				$$spec	Specialization	Pyromancy	Spells	Divination (Pyromancy)=13,Ignite Fire=13,Create Fire=13,Shape Fire=13,Extinguish Fire=13,Heat=13,Cold=13,Essential Flame=13,Resist Fire=13,Fireball=13,Flame Jet=13
				$$spec	Specialization	Rune-casting	Spells	Divination (Rune-casting)=13,Skills::Rune-Lore=15
			$$wiz(Shaman, 100, 10, 10, 15, 11)
				$$req	Advantages	World Sight
				$$choose	Advantages	15	Autotrance,Channelling,Charisma,Clerical Investment,Empathy,High Pain Threshold,Intuition,Magery=1,Medium,Racial Memory,Reawakened,Second Sight,Spirit Empathy,Status,Strong Will
				$$req	Disadvantages	Disciplines of Faith=Mysticism,Duty[Duty (To tribe or spirits)]=9 or less
				$$choose	Disadvantages	-15	Addiction[Addiction (Hallucinogen)]{Incapacitating or Hallucinogenic=-10},Age,Flashbacks,Loner,Reclusive,One Eye,One Hand,Primitive,Sense of Duty[Sense of Duty (Nature)]=3,Second Class Citizen,Voices,Vow,Epilepsy
				$$req	Skills	Occultism=14,Performance/Ritual=14,Theology=14
				$$choose	Skills	#1	Dancing=10,Herbalist=14,Meditation=13,Musical Instrument[Musical Instrument (Drum)]=14,Musical Instrument[Musical Instrument (Rattle)]=14,Singing=12
				$$choose	Skills	6	Animal Guise,Hidden Lore[Hidden Lore (Spirit Lore)],Language (MA)[Language (Spirit Language)],Exorcism,Hypnotism,Symbol Drawing,Breath Control,Dreaming
				$$choose	Skills	3	Acting,Bard,Fast-Talk,Leadership,Survival,Teaching,Diagnosis,Naturalist,Ventriloquism,Sleight of Hand
				$$req	Spells	Note[Choose 20 additional points of spells]
			$$wiz(Spy Wizard, 150, 10, 12, 14, 10)
				$$req	Advantages	Literacy,Magery=2
				$$choose	Advantages	20	Alertness,Alternate Identity,Appearance,Charisma,Danger Sense,Diplomatic Immunity,Empathy,Language Talent,Luck,Military Rank,Security Clearance,Strong Will,Voice
				$$req	Disadvantages	Duty=9 or less,Secret
				$$choose	Disadvantages	-20	Curious,Fanaticism,Greed,Lecherousness,Overconfidence,Paranoia,Sense of Duty[Sense of Duty (Nation)]=2,Trademark,Duty,Secret
				$$spec	Specialization	Social Skills	Skills	Acting=14,Disguise=14,*Language=14,Diplomacy=14 OR Savoir-Faire=15 OR Sex Appeal=10
				$$spec	Specialization	Physical Skills	Skills	Camouflage=14,Climbing=12,Lockpicking=13,Shadowing=14,Stealth=12,2:*Combat/Weapon
				$$choose	Skills	4	Area Knowledge=14,Heraldry=13,Holdout=13,Interrogation=13,Lip Reading=13,Research=13,Speed-Reading=13,Writing=13,Detect Lies=12,Psychology=12
				$$choose	Skills	2	Administration=13,Cartography=13,Surveying=13,Cryptanalysis=12,Cryptography=12,Forgery=12,Intelligence Analysis=12,Conspiracy Theory=11
				$$req	Spells	Sense Emotion,Sense Foes,Sense Life
				$$req	Spells	Illusion Disguise,Simple Illusion
				$$req	Spells	Colors,Light
				$$req	Spells	Copy,Dye,Restore
				$$req	Spells	Scryguard
				$$req	Spells	Alertness,Keen Ears,Keen Eyes
				$$req	Spells	Apportation
				$$req	Spells	Delayed Message,Far-Hearing,Hush,Mage-Stealth,Silence,Sound,Voices
				$$spec	Specialization	Communication and Empathy	Spells	Borrow Language,Compel Truth,Lend Language,mind-Reading,Mind-Search,Mind-Sending,Persuasion,Soul Rider,Telepathy,Truthsayer
				$$spec	Specialization	Earth, Knowledge and Water	Spells	Seek Earth,Analyze Magic,Glass Wall,History,Identify Spell,See Secrets,Seeker,Trace,Wizard Eye,Seek Water
				$$spec	Specialization	Light and Darkness	Spells	Blur,Continual Light,Dark Vision,Darkness,Hawk Vision,Hide,Infravision,Invisibility,Night Vision,See Invisible
				$$spec	Specialization	Mind Control	Spells	Bravery,Charm,Daze,Emotion Control,False Memory,Fear,Foolishness,Forgetfulness,Loyalty,Suggestion
				$$spec	Specialization	Movement	2:Spells	Ethereal Body,Flight,Hawk Flight,Levitation,Lockmaster,Locksmith,Manipulate,Teleport,Teleport Other

			# Super Mage, once again, is too open-ended to render here.

			$$wiz(Tech Wizard, 100, 9, 10, 14, 10, , , , , , , , GURPSSupers.cds)
				$$req	Advantages	Literacy,Magery=2
				$$choose	Advantages	25	Absolute Timing,Gadgeteer,High Technology,Intuition,Intuitive Mathematician,Lightning Calculator,Manual Dexterity,Mathematical Ability,Single-Minded,Tenure,Versatile
				$$choose	Disadvantages	-25	!Curious,!Compulsive Behavior,!Obsession,!Odious Personal Habit,Absent-Mindedness,*Bad Sight,Clueless,Oblivious,Pyromania,Stubbornness,Weirdness Magnet
				$$req	Skills	Cyphering=14,Mathematics=13,Research=13,Thaumatology=14
				$$choose	Skills	#4	Chemistry=13,*Engineering=13,Metallurgy=13,Physics=13,Alchemy=12,Weird Magic=12,Weird Science=12
				$$choose	Skills	#2	Scrounging,Abacus,Armoury,Demolition,Distilling,Dyeing,Lockpicking,*Mechanic,Teaching,Traps,Fireworks,Science!
				$$req	Spells	Seek Earth,Know Recipe,Seek Food,History,Measurement,Seeker,Trace,Apportation,Locksmith
				$$spec	Specialization	Making and Breaking	Spells	Purify Air,Shape Earth,Ignite Fire,Clean,Find Weakness,Rejoin,Repair,Reshape,Restore,Sharpen,Shatter,Shatterproof,Weaken,Seek Water
				$$spec	Specialization	Radiation	Spells	Create Air,Purify Air,Create Earth,Earth to Air,Earth to Stone,Shape Earth,Create Fire,Extinguish Fire,Ignite Fire,Extinguish Radiation,Irradiate,Resist Radiation,See Radiation,Seek Radiation
				$$spec	Specialization	Machines	Spells	Create Air,Destroy Air,Lightning,No-Smell,Odor,Purify Air,Stench,Glitch,Machine Control,Machine Speech,Machine Summoning,Reveal Function,Schematic,Seek Machine
				$$spec	Specialization	Metal and Plastic	Spells	Create Earth,Earth to Stone,Shape Earth,Shape Stone,Identify Plant,Seek Plant,Shape Plant,Identify Metal,Identify Plastic,Metal Vision,Plastic Vision,Seek Plastic,Shape Metal,Shape Plastic
				$$spec	Specialization	Energy	Spells	Lend Health,Lend Strength,Minor Healing,Infravision,Small Vision,Keen Ears,Keen Eyes,Conduct Power,Lend Power,magnetic Vision,Radio Hearing,Seek Power,Steal Power,Stop Power

			$$wiz(Thief Wizard, 100, 10, 13, 13, 10)
				$$req	Advantages	Literacy,Magery=1
				$$choose	Advantages	10	Absolute Direction,Absolute Timing,Acute Hearing,Acute Vision,Acute Taste and Smell,Alertness,Contacts,Double-Jointed,Manual Dexterity,Night Vision,Patron[Patron (Thieves' Guild)]
				$$req	Disadvantages	Greed OR Kleptomania OR Trickster
				$$choose	Disadvantages	-15	Code of Honor[Code of Honor (Pirates)],Duty[Duty (Thieves' Guild)],Enemy[Enemy (Law Enforcers)],Loner,Obsession[Obsession (Perfect Crime)],Reputation,Outlaw,Status,Poverty=Struggling
				$$req	Skills	Area Knowledge[Area Knowledge (City)]=13,Stealth=13,Streetwise=13
				$$choose	Skills	#3	Holdout=12,Lockpicking=12,Shadowing=12,Traps=12,Animal Handling=11,Starglazing=13,Climbing=12,Filch=12,Escape=11,Pickpocket=11,Running=8
				$$choose	Skills	2	*Combat/Weapon,Gesture,Fast-Talk,Gambling,Hidden Lore[Hidden Lore (City Secrets)],Intimidation,Merchant
				$$req	Spells	No-Smell,Purify Air,Seek Earth,Aura,Detect Magic,Identify Spell,See Secrets,Seeker,Counterspell,Dispel Magic,Scryguard
				$$req	Spells	Apportation,Lockmaster,Locksmith,Seek Water
				$$choose	Spells	#2	Climbing,Glass Wall,Measurement,Levitation,Lighten Burden,Manipulate,Undo,Wallwalker
				$$spec	Specialization	Invisibility	Spells	Blur,Continual Light,Darkness,Hide,Invisibility,Light,Night Vision,Keen Eyes
				$$spec	Specialization	Silence	Spells	Keen Ears,Far-Hearing,Hush,Mage-Stealth,Silence,Sound,Sound Vision,Wall of Silence
			end

		sublist "Lenses"
			memlist 
			$$template	Lens	Noncommissioned Officer	8	10	10	10	10			3	
				$$choose	Advantages	#1	Military Rank=1,Military Rank=2
				$$req	Skills	Savoir-Faire (Military)=#1
				$$choose	Skills	2	Administration,Intimidation,Leadership,Politics,Tactics
			$$template	Lens	Officer	20	10	10	10	10			3	
				$$req	Advantages	?Military Rank=3
				$$req	Skills	Savoir-Faire (Military)=#1,Strategy=#2 OR Tactics=#2
				$$choose	Skills	2	Administration,Intimidation,Leadership,Politics
			end 
		end
	end

# Load this here after the standard ones.

datafile GURPSProfessions.mds end

options
	list Advantages
		list Knack
			begin percent "Takes Less Time" "??1;20;x*20;x>0;Must be > 0"
				dispexp "format('l: Time/%d, +o%', 2^t)"
				end
			begin percent "Skill" "??0;0;(x<4?x*20:(x-3)*100);x>=0"
				dispexp "format('l: %d, +o%', t+15+magery)"
				end
			end
		end
	list "Super Limitations"
		percent "Affected by Magic Resistance" -10%
		percent "Mana Sensitive" -10%
		percent "Requires Material Component" -10%
		percent "Requires Rituals" "?:1;Gestures,-10%;Words,-10%;Gestures and words,-20%"
		end
	end

end
